/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.protobuf.ByteString;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractRepositories {
    protected AbstractRepositories() {
    }

    @Test
    void nonExistentRepository(@NessieDbAdapter(initializeRepo=false) @NessieDbAdapterConfigItem(name="repository.id", value="non-existent") DatabaseAdapter nonExistent) {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            try (Stream r = nonExistent.namedRefs(GetNamedRefsParams.DEFAULT);){
                Assertions.assertThat((Stream)r).isEmpty();
            }
        }, () -> Assertions.assertThatThrownBy(() -> nonExistent.hashOnReference((NamedRef)BranchName.of((String)"main"), Optional.empty())).isInstanceOf(ReferenceNotFoundException.class), () -> Assertions.assertThatThrownBy(() -> nonExistent.namedRef("main", GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class)});
    }

    @Test
    void multipleRepositories(@NessieDbAdapter @NessieDbAdapterConfigItem(name="repository.id", value="foo") DatabaseAdapter foo, @NessieDbAdapter @NessieDbAdapterConfigItem(name="repository.id", value="bar") DatabaseAdapter bar) throws Exception {
        BranchName main = BranchName.of((String)"main");
        BranchName fooBranchName = BranchName.of((String)"foo-branch");
        BranchName barBranchName = BranchName.of((String)"bar-branch");
        ByteString fooCommitMeta = ByteString.copyFromUtf8((String)"meta-foo");
        ByteString barCommitMeta = ByteString.copyFromUtf8((String)"meta-bar");
        OnRefOnly fooValue = OnRefOnly.onRef((String)"foo", (String)"foo");
        OnRefOnly barValue = OnRefOnly.onRef((String)"bar", (String)"bar");
        foo.commit((CommitParams)ImmutableCommitParams.builder().toBranch(main).commitMetaSerialized(fooCommitMeta).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"foo"}), (ContentId)ContentId.of((String)fooValue.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)fooValue), (ByteString)fooValue.serialized())).build());
        bar.commit((CommitParams)ImmutableCommitParams.builder().toBranch(main).commitMetaSerialized(barCommitMeta).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"bar"}), (ContentId)ContentId.of((String)barValue.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)barValue), (ByteString)barValue.serialized())).build());
        Hash fooMain = foo.hashOnReference((NamedRef)main, Optional.empty());
        Hash barMain = bar.hashOnReference((NamedRef)main, Optional.empty());
        Hash fooBranch = foo.create((NamedRef)fooBranchName, fooMain);
        Hash barBranch = bar.create((NamedRef)barBranchName, barMain);
        ((ObjectAssert)Assertions.assertThat((Object)fooMain).isNotEqualTo((Object)barMain)).isEqualTo((Object)fooBranch);
        ((ObjectAssert)Assertions.assertThat((Object)barMain).isNotEqualTo((Object)fooMain)).isEqualTo((Object)barBranch);
        try (Stream refs = foo.namedRefs(GetNamedRefsParams.DEFAULT);){
            Assertions.assertThat((Stream)refs).containsExactlyInAnyOrder((Object[])new ReferenceInfo[]{ReferenceInfo.of((Hash)fooMain, (NamedRef)main), ReferenceInfo.of((Hash)fooBranch, (NamedRef)fooBranchName)});
        }
        refs = bar.namedRefs(GetNamedRefsParams.DEFAULT);
        try {
            Assertions.assertThat((Stream)refs).containsExactlyInAnyOrder((Object[])new ReferenceInfo[]{ReferenceInfo.of((Hash)barMain, (NamedRef)main), ReferenceInfo.of((Hash)barBranch, (NamedRef)barBranchName)});
        }
        finally {
            if (refs != null) {
                refs.close();
            }
        }
        Assertions.assertThatThrownBy(() -> foo.commitLog(barBranch)).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThatThrownBy(() -> bar.commitLog(fooBranch)).isInstanceOf(ReferenceNotFoundException.class);
        try (Stream log = foo.commitLog(fooBranch);){
            Assertions.assertThat(log.collect(Collectors.toList())).extracting(CommitLogEntry::getMetadata).containsExactlyInAnyOrder((Object[])new ByteString[]{fooCommitMeta});
        }
        log = bar.commitLog(barBranch);
        try {
            Assertions.assertThat(log.collect(Collectors.toList())).extracting(CommitLogEntry::getMetadata).containsExactlyInAnyOrder((Object[])new ByteString[]{barCommitMeta});
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }
}

