/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.tx.TxConnectionConfig;
import org.projectnessie.versioned.persist.tx.TxDatabaseAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TxConnectionProvider<C extends TxConnectionConfig>
implements DatabaseConnectionProvider<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxConnectionProvider.class);
    private boolean setupDone;
    protected C config;

    public void configure(C config) {
        this.config = config;
    }

    public void initialize() throws SQLException {
    }

    public synchronized void setupDatabase(TxDatabaseAdapter adapter) {
        if (this.setupDone) {
            return;
        }
        try (Connection c = this.borrowConnection();){
            try (Statement st = c.createStatement();){
                boolean metadataUpperCase = adapter.metadataUpperCase();
                String catalog = this.config.getCatalog();
                String schema = this.config.getSchema();
                Map<TxDatabaseAdapter.NessieSqlDataType, String> dataTypes = adapter.databaseSqlFormatParameters();
                Object[] formatParamsArray = Arrays.stream(TxDatabaseAdapter.NessieSqlDataType.values()).map(dataTypes::get).toArray();
                Stream<String> ddls = adapter.allCreateTableDDL().entrySet().stream().filter(e -> !TxConnectionProvider.tableExists(c, metadataUpperCase, catalog, schema, (String)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).map(s -> MessageFormat.format(s, formatParamsArray));
                this.executeDDLs(adapter.batchDDL(), ddls, st);
            }
            this.setupDone = true;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void executeDDLs(boolean batchDDL, Stream<String> ddls, Statement st) throws SQLException {
        if (batchDDL) {
            String ddl = ddls.map(s -> s + ";").collect(Collectors.joining("\n\n"));
            if (!ddl.isEmpty()) {
                ddl = "BEGIN;\n" + ddl + "\nEND TRANSACTION;\n";
                LOGGER.debug("Executing DDL batch\n{}", (Object)ddl);
                st.execute(ddl);
            }
        } else {
            List ddlStatements = ddls.collect(Collectors.toList());
            for (String ddl : ddlStatements) {
                LOGGER.debug("Executing DDL: {}", (Object)ddl);
                st.execute(ddl);
            }
        }
    }

    private static boolean tableExists(Connection conn, boolean metadataUpperCase, String catalog, String schema, String table) {
        boolean bl;
        block9: {
            if (metadataUpperCase) {
                catalog = catalog != null ? catalog.toUpperCase(Locale.ROOT) : null;
                schema = schema != null ? schema.toUpperCase(Locale.ROOT) : null;
                table = table != null ? table.toUpperCase(Locale.ROOT) : null;
            }
            ResultSet tables = conn.getMetaData().getTables(catalog, schema, table, null);
            try {
                bl = tables.next();
                if (tables == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            tables.close();
        }
        return bl;
    }

    public abstract Connection borrowConnection() throws SQLException;
}

