/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ContentIdWithType;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.tx.JdbcSelectSpliterator;
import org.projectnessie.versioned.persist.tx.RetryTransactionException;
import org.projectnessie.versioned.persist.tx.SqlStatements;
import org.projectnessie.versioned.persist.tx.TxConnectionProvider;
import org.projectnessie.versioned.persist.tx.TxDatabaseAdapterConfig;

public abstract class TxDatabaseAdapter
extends AbstractDatabaseAdapter<Connection, TxDatabaseAdapterConfig> {
    protected static final String REF_TYPE_BRANCH = "b";
    protected static final String REF_TYPE_TAG = "t";
    private final TxConnectionProvider<?> db;
    protected static final String DEADLOCK_SQL_STATE_POSTGRES = "40P01";
    protected static final String RETRY_SQL_STATE_COCKROACH = "40001";
    protected static final String CONSTRAINT_VIOLATION_SQL_STATE = "23505";
    protected static final int CONSTRAINT_VIOLATION_SQL_CODE = 23505;

    public TxDatabaseAdapter(TxDatabaseAdapterConfig config, TxConnectionProvider<?> db) {
        super((DatabaseAdapterConfig)config);
        Objects.requireNonNull(db, "TxDatabaseAdapter requires a non-null TxConnectionProvider via TxDatabaseAdapterConfig.getConnectionProvider()");
        this.db = db;
        db.setupDatabase(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        Connection conn = this.borrowConnection();
        try {
            Hash hash = this.hashOnRef(conn, namedReference, hashOnReference);
            return hash;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Key, ContentAndState<ByteString>> values(Hash commit, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        Connection conn = this.borrowConnection();
        try {
            Map map = this.fetchValues(conn, commit, keys, keyFilter);
            return map;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<CommitLogEntry> commitLog(Hash offset) throws ReferenceNotFoundException {
        Connection conn = this.borrowConnection();
        boolean failed = true;
        try {
            Stream intLog = this.readCommitLogStream(conn, offset);
            failed = false;
            Stream stream = (Stream)intLog.onClose(() -> this.releaseConnection(conn));
            return stream;
        }
        finally {
            if (failed) {
                this.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceInfo<ByteString> namedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null");
        Connection conn = this.borrowConnection();
        try {
            ReferenceInfo<ByteString> refInfo = this.fetchNamedRef(conn, ref);
            Hash defaultBranchHead = this.namedRefsDefaultBranchHead(conn, params);
            Stream<ReferenceInfo<ByteString>> refs = Stream.of(refInfo);
            ReferenceInfo referenceInfo = (ReferenceInfo)this.namedRefsFilterAndEnhance(conn, params, defaultBranchHead, refs).findFirst().orElseThrow(() -> DatabaseAdapterUtil.referenceNotFound((String)ref));
            return referenceInfo;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null.");
        Preconditions.checkArgument((boolean)TxDatabaseAdapter.namedRefsAnyRetrieves((GetNamedRefsParams)params), (Object)"Must retrieve branches or tags or both.");
        Connection conn = this.borrowConnection();
        boolean failed = true;
        try {
            Hash defaultBranchHead = this.namedRefsDefaultBranchHead(conn, params);
            Stream refs = this.fetchNamedRefs(conn);
            refs = this.namedRefsFilterAndEnhance(conn, params, defaultBranchHead, refs);
            failed = false;
            Stream stream = (Stream)refs.onClose(() -> this.releaseConnection(conn));
            return stream;
        }
        finally {
            if (failed) {
                this.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<KeyWithType> keys(Hash commit, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        Connection conn = this.borrowConnection();
        boolean failed = true;
        try {
            Stream r = this.keysForCommitEntry(conn, commit, keyFilter);
            failed = false;
            Stream stream = (Stream)r.onClose(() -> this.releaseConnection(conn));
            return stream;
        }
        finally {
            if (failed) {
                this.releaseConnection(conn);
            }
        }
    }

    public Hash merge(Hash from, BranchName toBranch, Optional<Hash> expectedHead, Function<ByteString, ByteString> updateCommitMetadata) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return this.opLoop((NamedRef)toBranch, false, (conn, currentHead) -> {
                long timeInMicros = this.commitTimeInMicros();
                Hash toHead = this.mergeAttempt(conn, timeInMicros, from, toBranch, expectedHead, currentHead, h -> {}, h -> {}, updateCommitMetadata);
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)toBranch, currentHead, toHead);
                this.commitRefLog(conn, timeInMicros, toHead, (NamedRef)toBranch, AdapterTypes.RefLogEntry.Operation.MERGE, Collections.singletonList(from));
                return resultHash;
            }, () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Conflict", (Hash)from, (BranchName)toBranch, (Optional)expectedHead), () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Retry-failure", (Hash)from, (BranchName)toBranch, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash transplant(BranchName targetBranch, Optional<Hash> expectedHead, List<Hash> commits, Function<ByteString, ByteString> updateCommitMetadata) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return this.opLoop((NamedRef)targetBranch, false, (conn, currentHead) -> {
                long timeInMicros = this.commitTimeInMicros();
                Hash targetHead = this.transplantAttempt(conn, timeInMicros, targetBranch, expectedHead, currentHead, commits, h -> {}, h -> {}, updateCommitMetadata);
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)targetBranch, currentHead, targetHead);
                this.commitRefLog(conn, timeInMicros, targetHead, (NamedRef)targetBranch, AdapterTypes.RefLogEntry.Operation.TRANSPLANT, commits);
                return resultHash;
            }, () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Conflict", (BranchName)targetBranch, (Optional)expectedHead, (List)commits), () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Retry-failure", (BranchName)targetBranch, (Optional)expectedHead, (List)commits));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash commit(CommitAttempt commitAttempt) throws ReferenceConflictException, ReferenceNotFoundException {
        try {
            return this.opLoop((NamedRef)commitAttempt.getCommitToBranch(), false, (conn, branchHead) -> {
                long timeInMicros = this.commitTimeInMicros();
                CommitLogEntry newBranchCommit = this.commitAttempt(conn, timeInMicros, branchHead, commitAttempt, h -> {});
                this.upsertGlobalStates(commitAttempt, conn, newBranchCommit.getCreatedTime());
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)commitAttempt.getCommitToBranch(), branchHead, newBranchCommit.getHash());
                this.commitRefLog(conn, timeInMicros, newBranchCommit.getHash(), (NamedRef)commitAttempt.getCommitToBranch(), AdapterTypes.RefLogEntry.Operation.COMMIT, Collections.emptyList());
                return resultHash;
            }, () -> DatabaseAdapterUtil.commitConflictMessage((String)"Conflict", (BranchName)commitAttempt.getCommitToBranch(), (Optional)commitAttempt.getExpectedHead()), () -> DatabaseAdapterUtil.commitConflictMessage((String)"Retry-Failure", (BranchName)commitAttempt.getCommitToBranch(), (Optional)commitAttempt.getExpectedHead()));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash create(NamedRef ref, Hash target) throws ReferenceAlreadyExistsException, ReferenceNotFoundException {
        try {
            return this.opLoop(ref, true, (conn, nullHead) -> {
                if (this.checkNamedRefExistence(conn, ref.getName())) {
                    throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
                }
                Hash hash = target;
                if (hash == null) {
                    hash = NO_ANCESTOR;
                }
                this.validateHashExists(conn, hash);
                this.insertNewReference(conn, ref, hash);
                this.commitRefLog(conn, this.commitTimeInMicros(), hash, ref, AdapterTypes.RefLogEntry.Operation.CREATE_REFERENCE, Collections.emptyList());
                return hash;
            }, () -> DatabaseAdapterUtil.createConflictMessage((String)"Conflict", (NamedRef)ref, (Hash)target), () -> DatabaseAdapterUtil.createConflictMessage((String)"Retry-Failure", (NamedRef)ref, (Hash)target));
        }
        catch (RuntimeException | ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(NamedRef reference, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.opLoop(reference, false, (conn, pointer) -> {
                DatabaseAdapterUtil.verifyExpectedHash((Hash)pointer, (NamedRef)reference, (Optional)expectedHead);
                Hash commitHash = this.fetchNamedRefHead(conn, reference);
                try (PreparedStatement ps = conn.prepareStatement(SqlStatements.DELETE_NAMED_REFERENCE);){
                    ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(2, reference.getName());
                    ps.setString(3, pointer.asString());
                    if (ps.executeUpdate() != 1) {
                        Hash hash = null;
                        return hash;
                    }
                }
                this.commitRefLog(conn, this.commitTimeInMicros(), commitHash, reference, AdapterTypes.RefLogEntry.Operation.DELETE_REFERENCE, Collections.emptyList());
                return pointer;
            }, () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Conflict", (NamedRef)reference, (Optional)expectedHead), () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Retry-Failure", (NamedRef)reference, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assign(NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.opLoop(assignee, true, (conn, pointer) -> {
                pointer = this.fetchNamedRefHead(conn, assignee);
                DatabaseAdapterUtil.verifyExpectedHash((Hash)pointer, (NamedRef)assignee, (Optional)expectedHead);
                if (!NO_ANCESTOR.equals((Object)assignTo) && this.fetchFromCommitLog(conn, assignTo) == null) {
                    throw DatabaseAdapterUtil.referenceNotFound((Hash)assignTo);
                }
                Hash resultHash = this.tryMoveNamedReference(conn, assignee, pointer, assignTo);
                this.commitRefLog(conn, this.commitTimeInMicros(), assignTo, assignee, AdapterTypes.RefLogEntry.Operation.ASSIGN_REFERENCE, Collections.emptyList());
                return resultHash;
            }, () -> DatabaseAdapterUtil.assignConflictMessage((String)"Conflict", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo), () -> DatabaseAdapterUtil.assignConflictMessage((String)"Retry-Failure", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Difference> diff(Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        Connection conn = this.borrowConnection();
        try {
            Stream stream = this.buildDiff(conn, from, to, keyFilter);
            return stream;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    public void initializeRepo(String defaultBranchName) {
        Connection conn = this.borrowConnection();
        try {
            if (!this.checkNamedRefExistence(conn, (NamedRef)BranchName.of((String)defaultBranchName))) {
                this.insertNewReference(conn, (NamedRef)BranchName.of((String)defaultBranchName), NO_ANCESTOR);
                Hash newRefLogId = this.writeRefLogEntry(conn, (NamedRef)BranchName.of((String)defaultBranchName), NO_ANCESTOR, NO_ANCESTOR, AdapterTypes.RefLogEntry.Operation.CREATE_REFERENCE, this.commitTimeInMicros(), Collections.emptyList());
                this.insertRefLogHead(newRefLogId, conn);
                this.txCommit(conn);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    public void eraseRepo() {
        Connection conn = this.borrowConnection();
        try {
            try (PreparedStatement ps = conn.prepareStatement(SqlStatements.DELETE_NAMED_REFERENCE_ALL);){
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            ps = conn.prepareStatement(SqlStatements.DELETE_GLOBAL_STATE_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.prepareStatement(SqlStatements.DELETE_COMMIT_LOG_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.prepareStatement(SqlStatements.DELETE_KEY_LIST_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.prepareStatement(SqlStatements.DELETE_REF_LOG_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.prepareStatement(SqlStatements.DELETE_REF_LOG_HEAD_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            this.txCommit(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    public Stream<ContentIdWithType> globalKeys(ToIntFunction<ByteString> contentTypeExtractor) {
        Connection conn = this.borrowConnection();
        return (Stream)JdbcSelectSpliterator.buildStream(conn, SqlStatements.SELECT_GLOBAL_STATE_ALL, ps -> ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId()), rs -> {
            ContentId contentId = ContentId.of((String)rs.getString(1));
            byte[] value = rs.getBytes(2);
            byte type = (byte)contentTypeExtractor.applyAsInt(UnsafeByteOperations.unsafeWrap((byte[])value));
            return ContentIdWithType.of((ContentId)contentId, (byte)type);
        }).onClose(() -> this.releaseConnection(conn));
    }

    public Optional<ContentIdAndBytes> globalContent(ContentId contentId, ToIntFunction<ByteString> contentTypeExtractor) {
        Connection conn = this.borrowConnection();
        try {
            try (Object ps = conn.prepareStatement(String.format(SqlStatements.SELECT_GLOBAL_STATE_MANY, "?"));){
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, contentId.getId());
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        Optional<ContentIdAndBytes> optional = Optional.of(this.globalContentFromRow(contentTypeExtractor, rs));
                        return optional;
                    }
                }
            }
            ps = Optional.empty();
            return ps;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    public Stream<ContentIdAndBytes> globalContent(Set<ContentId> keys, ToIntFunction<ByteString> contentTypeExtractor) {
        Connection conn = this.borrowConnection();
        return (Stream)JdbcSelectSpliterator.buildStream(conn, this.sqlForManyPlaceholders(SqlStatements.SELECT_GLOBAL_STATE_MANY_WITH_LOGS, keys.size()), ps -> {
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            int i = 2;
            for (ContentId key : keys) {
                ps.setString(i++, key.getId());
            }
        }, rs -> {
            ContentIdAndBytes global = this.globalContentFromRow(contentTypeExtractor, rs);
            if (!keys.contains(global.getContentId())) {
                return null;
            }
            return global;
        }).onClose(() -> this.releaseConnection(conn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<RefLog> refLog(Hash offset) throws RefLogNotFoundException {
        Connection conn = this.borrowConnection();
        boolean failed = true;
        try {
            Stream intLog = this.readRefLogStream(conn, offset);
            failed = false;
            Stream stream = (Stream)intLog.onClose(() -> this.releaseConnection(conn));
            return stream;
        }
        finally {
            if (failed) {
                this.releaseConnection(conn);
            }
        }
    }

    private ContentIdAndBytes globalContentFromRow(ToIntFunction<ByteString> contentTypeExtractor, ResultSet rs) throws SQLException {
        ContentId cid = ContentId.of((String)rs.getString(1));
        ByteString value = UnsafeByteOperations.unsafeWrap((byte[])rs.getBytes(2));
        byte type = (byte)contentTypeExtractor.applyAsInt(value);
        return ContentIdAndBytes.of((ContentId)cid, (byte)type, (ByteString)value);
    }

    protected Hash hashOnRef(Connection conn, NamedRef reference, Optional<Hash> hashOnRef) throws ReferenceNotFoundException {
        return this.hashOnRef(conn, reference, hashOnRef, this.fetchNamedRefHead(conn, reference));
    }

    private void releaseConnection(Connection conn) {
        try {
            try {
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyWithType entry) {
        return ProtoSerialization.toProto((KeyWithType)entry).getSerializedSize();
    }

    protected Connection borrowConnection() {
        try {
            return this.db.borrowConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void txCommit(Connection conn) {
        try {
            conn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void txRollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Hash opLoop(NamedRef namedReference, boolean createRef, LoopOp loopOp, Supplier<String> conflictErrorMessage, Supplier<String> retryErrorMessage) throws VersionStoreException {
        Connection conn = this.borrowConnection();
        try (TryLoopState tryState = TryLoopState.newTryLoopState(retryErrorMessage, (DatabaseAdapterConfig)this.config);){
            while (true) {
                Hash newHead;
                Hash pointer = createRef ? null : this.fetchNamedRefHead(conn, namedReference);
                try {
                    newHead = loopOp.apply(conn, pointer);
                }
                catch (RetryTransactionException e) {
                    this.txRollback(conn);
                    tryState.retry();
                    continue;
                }
                catch (SQLException e) {
                    if (this.isRetryTransaction(e)) {
                        this.txRollback(conn);
                        tryState.retry();
                        continue;
                    }
                    this.throwIfReferenceConflictException(e, conflictErrorMessage);
                    throw new RuntimeException(e);
                }
                if (newHead != null) {
                    this.txCommit(conn);
                    Hash hash = tryState.success(newHead);
                    return hash;
                }
                this.txRollback(conn);
                tryState.retry();
            }
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    protected Stream<ReferenceInfo<ByteString>> fetchNamedRefs(Connection conn) {
        return JdbcSelectSpliterator.buildStream(conn, SqlStatements.SELECT_NAMED_REFERENCES, ps -> ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId()), rs -> {
            String type = rs.getString(1);
            String ref = rs.getString(2);
            Hash head = Hash.of((String)rs.getString(3));
            NamedRef namedRef = this.namedRefFromRow(type, ref);
            if (namedRef != null) {
                return ReferenceInfo.of((Hash)head, (NamedRef)namedRef);
            }
            return null;
        });
    }

    protected boolean checkNamedRefExistence(Connection c, NamedRef ref) {
        try {
            this.fetchNamedRefHead(c, ref);
            return true;
        }
        catch (ReferenceNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean checkNamedRefExistence(Connection c, String refName) {
        try (PreparedStatement ps = c.prepareStatement(SqlStatements.SELECT_NAMED_REFERENCE_NAME);){
            boolean bl;
            block14: {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, refName);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Hash fetchNamedRefHead(Connection c, NamedRef ref) throws ReferenceNotFoundException {
        try (PreparedStatement ps = c.prepareStatement(SqlStatements.SELECT_NAMED_REFERENCE);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref.getName());
            ps.setString(3, this.referenceTypeDiscriminator(ref));
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
                Hash hash = Hash.of((String)rs.getString(1));
                return hash;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReferenceInfo<ByteString> fetchNamedRef(Connection c, String ref) throws ReferenceNotFoundException {
        try (PreparedStatement ps = c.prepareStatement(SqlStatements.SELECT_NAMED_REFERENCE_ANY);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw DatabaseAdapterUtil.referenceNotFound((String)ref);
                Hash hash = Hash.of((String)rs.getString(2));
                NamedRef namedRef = this.namedRefFromRow(rs.getString(1), ref);
                ReferenceInfo referenceInfo = ReferenceInfo.of((Hash)hash, (NamedRef)namedRef);
                return referenceInfo;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected NamedRef namedRefFromRow(String type, String ref) {
        switch (type) {
            case "b": {
                return BranchName.of((String)ref);
            }
            case "t": {
                return TagName.of((String)ref);
            }
        }
        return null;
    }

    protected void insertNewReference(Connection conn, NamedRef ref, Hash hash) throws ReferenceAlreadyExistsException, SQLException {
        try (PreparedStatement ps = conn.prepareStatement(SqlStatements.INSERT_NAMED_REFERENCE);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref.getName());
            ps.setString(3, this.referenceTypeDiscriminator(ref));
            ps.setString(4, hash.asString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isIntegrityConstraintViolation(e)) {
                throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
            }
            throw e;
        }
    }

    protected String referenceTypeDiscriminator(NamedRef ref) {
        String refType;
        if (ref instanceof BranchName) {
            refType = REF_TYPE_BRANCH;
        } else if (ref instanceof TagName) {
            refType = REF_TYPE_TAG;
        } else {
            throw new IllegalArgumentException();
        }
        return refType;
    }

    private Hash namedRefsDefaultBranchHead(Connection conn, GetNamedRefsParams params) throws ReferenceNotFoundException {
        if (TxDatabaseAdapter.namedRefsRequiresBaseReference((GetNamedRefsParams)params)) {
            Preconditions.checkNotNull((Object)params.getBaseReference(), (Object)"Base reference name missing.");
            return this.fetchNamedRefHead(conn, params.getBaseReference());
        }
        return null;
    }

    protected void upsertGlobalStates(CommitAttempt commitAttempt, Connection conn, long newCreatedAt) throws SQLException {
        block37: {
            if (commitAttempt.getGlobal().isEmpty()) {
                return;
            }
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_GLOBAL_STATE_MANY_WITH_LOGS, commitAttempt.getGlobal().size());
            HashSet newKeys = new HashSet(commitAttempt.getGlobal().keySet());
            try (PreparedStatement psSelect = conn.prepareStatement(sql);
                 PreparedStatement psUpdate = conn.prepareStatement(SqlStatements.UPDATE_GLOBAL_STATE);
                 PreparedStatement psUpdateUnconditional = conn.prepareStatement(SqlStatements.UPDATE_GLOBAL_STATE_UNCOND);){
                String newHash;
                psSelect.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int i = 2;
                for (ContentId cid : commitAttempt.getGlobal().keySet()) {
                    psSelect.setString(i++, cid.getId());
                }
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        ContentId contentId = ContentId.of((String)rs.getString(1));
                        newKeys.remove(contentId);
                        ByteString newState = (ByteString)commitAttempt.getGlobal().get(contentId);
                        ByteString expected = commitAttempt.getExpectedStates().getOrDefault(contentId, Optional.empty()).orElse(ByteString.EMPTY);
                        byte[] newStateBytes = newState.toByteArray();
                        newHash = DatabaseAdapterUtil.newHasher().putBytes(newStateBytes).hash().toString();
                        PreparedStatement ps = expected.isEmpty() ? psUpdateUnconditional : psUpdate;
                        ps.setBytes(1, newStateBytes);
                        ps.setString(2, newHash);
                        ps.setLong(3, newCreatedAt);
                        ps.setString(4, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                        ps.setString(5, contentId.getId());
                        if (!expected.isEmpty()) {
                            String expectedHash = DatabaseAdapterUtil.newHasher().putBytes(expected.asReadOnlyByteBuffer()).hash().toString();
                            ps.setString(6, expectedHash);
                        }
                        if (ps.executeUpdate() == 1) continue;
                        throw this.newIntegrityConstraintViolationException();
                    }
                }
                if (newKeys.isEmpty()) break block37;
                try (PreparedStatement psInsert = conn.prepareStatement(SqlStatements.INSERT_GLOBAL_STATE);){
                    for (ContentId contentId : newKeys) {
                        ByteString newGlob = (ByteString)commitAttempt.getGlobal().get(contentId);
                        byte[] newGlobBytes = newGlob.toByteArray();
                        newHash = DatabaseAdapterUtil.newHasher().putBytes(newGlobBytes).hash().toString();
                        if (contentId == null) {
                            throw new IllegalArgumentException(String.format("No contentId in CommitAttempt.keyToContent content-id '%s'", contentId));
                        }
                        psInsert.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                        psInsert.setString(2, contentId.getId());
                        psInsert.setString(3, newHash);
                        psInsert.setBytes(4, newGlobBytes);
                        psInsert.setLong(5, newCreatedAt);
                        psInsert.executeUpdate();
                    }
                }
            }
        }
    }

    protected String sqlForManyPlaceholders(String sql, int num) {
        String placeholders = IntStream.range(0, num).mapToObj(x -> "?").collect(Collectors.joining(", "));
        return String.format(sql, placeholders);
    }

    protected Map<ContentId, ByteString> fetchGlobalStates(Connection conn, Set<ContentId> contentIds) {
        HashMap<ContentId, ByteString> hashMap;
        block18: {
            if (contentIds.isEmpty()) {
                return Collections.emptyMap();
            }
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_GLOBAL_STATE_MANY, contentIds.size());
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int i = 2;
                for (ContentId cid : contentIds) {
                    ps.setString(i++, cid.getId());
                }
                HashMap<ContentId, ByteString> result = new HashMap<ContentId, ByteString>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        ContentId contentId = ContentId.of((String)rs.getString(1));
                        if (!contentIds.contains(contentId)) continue;
                        byte[] data = rs.getBytes(2);
                        ByteString val = UnsafeByteOperations.unsafeWrap((byte[])data);
                        result.put(contentId, val);
                    }
                }
                hashMap = result;
                if (ps == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return hashMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected CommitLogEntry fetchFromCommitLog(Connection c, Hash hash) {
        try (PreparedStatement ps = c.prepareStatement(SqlStatements.SELECT_COMMIT_LOG);){
            CommitLogEntry commitLogEntry;
            block14: {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, hash.asString());
                ResultSet rs = ps.executeQuery();
                try {
                    CommitLogEntry commitLogEntry2 = commitLogEntry = rs.next() ? ProtoSerialization.protoToCommitLogEntry((byte[])rs.getBytes(1)) : null;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return commitLogEntry;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<CommitLogEntry> fetchPageFromCommitLog(Connection c, List<Hash> hashes) {
        List<CommitLogEntry> list;
        block17: {
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_COMMIT_LOG_MANY, hashes.size());
            PreparedStatement ps = c.prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                for (int i = 0; i < hashes.size(); ++i) {
                    ps.setString(2 + i, hashes.get(i).asString());
                }
                HashMap<Hash, CommitLogEntry> result = new HashMap<Hash, CommitLogEntry>(hashes.size() * 2);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        CommitLogEntry entry = ProtoSerialization.protoToCommitLogEntry((byte[])rs.getBytes(1));
                        result.put(entry.getHash(), entry);
                    }
                }
                list = hashes.stream().map(result::get).collect(Collectors.toList());
                if (ps == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return list;
    }

    protected void writeIndividualCommit(Connection c, CommitLogEntry entry) throws ReferenceConflictException {
        try (PreparedStatement ps = c.prepareStatement(SqlStatements.INSERT_COMMIT_LOG);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, entry.getHash().asString());
            ps.setBytes(3, ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for '%s' in commit-log", entry.getHash()));
            throw new RuntimeException(e);
        }
    }

    protected void writeMultipleCommits(Connection c, List<CommitLogEntry> entries) throws ReferenceConflictException {
        this.writeMany(c, SqlStatements.INSERT_COMMIT_LOG, entries, e -> e.getHash().asString(), e -> ProtoSerialization.toProto((CommitLogEntry)e).toByteArray());
    }

    protected void writeKeyListEntities(Connection c, List<KeyListEntity> newKeyListEntities) {
        try {
            this.writeMany(c, SqlStatements.INSERT_KEY_LIST, newKeyListEntities, e -> e.getId().asString(), e -> ProtoSerialization.toProto((KeyList)e.getKeys()).toByteArray());
        }
        catch (ReferenceConflictException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected <T> void writeMany(Connection c, String sqlInsert, List<T> entries, Function<T, String> idRetriever, Function<T, byte[]> serializer) throws ReferenceConflictException {
        int cnt = 0;
        try (PreparedStatement ps = c.prepareStatement(sqlInsert);){
            for (T e : entries) {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, idRetriever.apply(e));
                ps.setBytes(3, serializer.apply(e));
                ps.addBatch();
                if (++cnt != ((TxDatabaseAdapterConfig)this.config).getBatchSize()) continue;
                ps.executeBatch();
                cnt = 0;
            }
            if (cnt > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for one of the hashes %s in commit-log", entries.stream().map(x -> "'" + (String)idRetriever.apply(x) + "'").collect(Collectors.joining(", "))));
            throw new RuntimeException(e);
        }
    }

    protected Stream<KeyListEntity> fetchKeyLists(Connection c, List<Hash> keyListsIds) {
        return JdbcSelectSpliterator.buildStream(c, this.sqlForManyPlaceholders(SqlStatements.SELECT_KEY_LIST_MANY, keyListsIds.size()), ps -> {
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            int i = 2;
            for (Hash id : keyListsIds) {
                ps.setString(i++, id.asString());
            }
        }, rs -> KeyListEntity.of((Hash)Hash.of((String)rs.getString(1)), (KeyList)ProtoSerialization.protoToKeyList((byte[])rs.getBytes(2))));
    }

    protected void throwIfReferenceConflictException(SQLException e, Supplier<String> message) throws ReferenceConflictException {
        if (this.isIntegrityConstraintViolation(e)) {
            throw new ReferenceConflictException(message.get(), (Throwable)e);
        }
    }

    protected SQLException newIntegrityConstraintViolationException() {
        return new SQLIntegrityConstraintViolationException();
    }

    protected boolean isIntegrityConstraintViolation(Throwable e) {
        if (e instanceof SQLException) {
            SQLException sqlException = (SQLException)e;
            return sqlException instanceof SQLIntegrityConstraintViolationException || 23505 == sqlException.getErrorCode() || CONSTRAINT_VIOLATION_SQL_STATE.equals(sqlException.getSQLState());
        }
        return false;
    }

    protected boolean isRetryTransaction(SQLException e) {
        if (e.getSQLState() == null) {
            return false;
        }
        switch (e.getSQLState()) {
            case "40P01": 
            case "40001": {
                return true;
            }
        }
        return false;
    }

    protected Hash tryMoveNamedReference(Connection conn, NamedRef ref, Hash expectedHead, Hash newHead) {
        Hash hash;
        block9: {
            PreparedStatement ps = conn.prepareStatement(SqlStatements.UPDATE_NAMED_REFERENCE);
            try {
                ps.setString(1, newHead.asString());
                ps.setString(2, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(3, ref.getName());
                ps.setString(4, expectedHead.asString());
                Object object = hash = ps.executeUpdate() == 1 ? newHead : null;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (this.isRetryTransaction(e)) {
                        throw new RetryTransactionException();
                    }
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return hash;
    }

    protected Map<String, List<String>> allCreateTableDDL() {
        return ImmutableMap.builder().put((Object)"global_state", Collections.singletonList(SqlStatements.CREATE_TABLE_GLOBAL_STATE)).put((Object)"named_refs", Collections.singletonList(SqlStatements.CREATE_TABLE_NAMED_REFERENCES)).put((Object)"commit_log", Collections.singletonList(SqlStatements.CREATE_TABLE_COMMIT_LOG)).put((Object)"key_list", Collections.singletonList(SqlStatements.CREATE_TABLE_KEY_LIST)).put((Object)"ref_log", Collections.singletonList(SqlStatements.CREATE_TABLE_REF_LOG)).put((Object)"ref_log_head", Collections.singletonList(SqlStatements.CREATE_TABLE_REF_LOG_HEAD)).build();
    }

    protected abstract Map<NessieSqlDataType, String> databaseSqlFormatParameters();

    protected boolean metadataUpperCase() {
        return true;
    }

    protected boolean batchDDL() {
        return false;
    }

    private AdapterTypes.RefLogEntry buildRefLogEntry(NamedRef ref, Hash parentRefLogId, Hash commitHash, AdapterTypes.RefLogEntry.Operation operation, long timeInMicros, List<Hash> sourceHashes, RefLog parentEntry) {
        Stream<Hash> newParents = Stream.of(parentRefLogId);
        if (parentEntry != null) {
            newParents = Stream.concat(newParents, parentEntry.getParents().stream().limit(((TxDatabaseAdapterConfig)this.config).getParentsPerRefLogEntry() - 1));
        }
        AdapterTypes.RefLogEntry.RefType refType = ref instanceof TagName ? AdapterTypes.RefLogEntry.RefType.Tag : AdapterTypes.RefLogEntry.RefType.Branch;
        AdapterTypes.RefLogEntry.Builder entry = AdapterTypes.RefLogEntry.newBuilder().setRefLogId(DatabaseAdapterUtil.randomHash().asBytes()).setRefName(ByteString.copyFromUtf8((String)ref.getName())).setRefType(refType).setCommitHash(commitHash.asBytes()).setOperationTime(timeInMicros).setOperation(operation);
        sourceHashes.forEach(hash -> entry.addSourceHashes(hash.asBytes()));
        newParents.forEach(p -> entry.addParents(p.asBytes()));
        return entry.build();
    }

    protected void updateRefLogHead(Hash newRefLogId, Hash parentRefLogId, Connection conn) throws SQLException {
        PreparedStatement psUpdate = conn.prepareStatement(SqlStatements.UPDATE_REF_LOG_HEAD);
        psUpdate.setString(1, newRefLogId.asString());
        psUpdate.setString(2, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
        psUpdate.setString(3, parentRefLogId.asString());
        if (psUpdate.executeUpdate() != 1) {
            throw new RetryTransactionException();
        }
    }

    protected void insertRefLogHead(Hash newRefLogId, Connection conn) throws SQLException {
        PreparedStatement selectStatement = conn.prepareStatement(SqlStatements.SELECT_REF_LOG_HEAD);
        selectStatement.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
        if (!selectStatement.executeQuery().next()) {
            PreparedStatement psUpdate = conn.prepareStatement(SqlStatements.INSERT_REF_LOG_HEAD);
            psUpdate.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            psUpdate.setString(2, newRefLogId.asString());
            if (psUpdate.executeUpdate() != 1) {
                throw this.newIntegrityConstraintViolationException();
            }
        }
    }

    protected Hash getRefLogHead(Connection conn) throws SQLException {
        PreparedStatement psSelect = conn.prepareStatement(SqlStatements.SELECT_REF_LOG_HEAD);
        psSelect.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
        ResultSet resultSet = psSelect.executeQuery();
        if (resultSet.next()) {
            return Hash.of((String)resultSet.getString(1));
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected RefLog fetchFromRefLog(Connection connection, Hash refLogId) {
        if (refLogId == null) {
            try {
                refLogId = this.getRefLogHead(connection);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try (PreparedStatement ps = connection.prepareStatement(SqlStatements.SELECT_REF_LOG);){
            RefLog refLog;
            block17: {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, refLogId.asString());
                ResultSet rs = ps.executeQuery();
                try {
                    RefLog refLog2 = refLog = rs.next() ? ProtoSerialization.protoToRefLog((byte[])rs.getBytes(1)) : null;
                    if (rs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return refLog;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<RefLog> fetchPageFromRefLog(Connection connection, List<Hash> hashes) {
        List<RefLog> list;
        block17: {
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_REF_LOG_MANY, hashes.size());
            PreparedStatement ps = connection.prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                for (int i = 0; i < hashes.size(); ++i) {
                    ps.setString(2 + i, hashes.get(i).asString());
                }
                HashMap<Hash, RefLog> result = new HashMap<Hash, RefLog>(hashes.size() * 2);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        RefLog entry = ProtoSerialization.protoToRefLog((byte[])rs.getBytes(1));
                        result.put(Objects.requireNonNull(entry).getRefLogId(), entry);
                    }
                }
                list = hashes.stream().map(result::get).collect(Collectors.toList());
                if (ps == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return list;
    }

    private void commitRefLog(Connection conn, long timeInMicros, Hash commitHash, NamedRef ref, AdapterTypes.RefLogEntry.Operation operation, List<Hash> sourceHashes) throws SQLException, ReferenceConflictException {
        Hash parentId = this.getRefLogHead(conn);
        Hash newRefLogId = this.writeRefLogEntry(conn, ref, parentId, commitHash, operation, timeInMicros, sourceHashes);
        this.updateRefLogHead(newRefLogId, parentId, conn);
    }

    private Hash writeRefLogEntry(Connection connection, NamedRef ref, Hash parentRefLogId, Hash commitHash, AdapterTypes.RefLogEntry.Operation operation, long timeInMicros, List<Hash> sourceHashes) throws ReferenceConflictException {
        RefLog parentEntry = this.fetchFromRefLog(connection, parentRefLogId);
        AdapterTypes.RefLogEntry refLogEntry = this.buildRefLogEntry(ref, parentRefLogId, commitHash, operation, timeInMicros, sourceHashes, parentEntry);
        this.writeRefLog(connection, refLogEntry);
        return Hash.of((ByteString)refLogEntry.getRefLogId());
    }

    private void writeRefLog(Connection connection, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        try (PreparedStatement ps = connection.prepareStatement(SqlStatements.INSERT_REF_LOG);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, Hash.of((ByteString)entry.getRefLogId()).asString());
            ps.setBytes(3, entry.toByteArray());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for '%s' in ref-log", entry.getRefLogId()));
            throw new RuntimeException(e);
        }
    }

    protected static enum NessieSqlDataType {
        BLOB,
        HASH,
        KEY_PREFIX,
        KEY,
        NAMED_REF,
        NAMED_REF_TYPE,
        CONTENT_ID,
        INTEGER;

    }

    @FunctionalInterface
    public static interface LoopOp {
        public Hash apply(Connection var1, Hash var2) throws VersionStoreException, SQLException;
    }
}

