/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.AdjustableDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.tx.AdjustableTxDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.tx.TxDatabaseAdapterConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AdjustableTxDatabaseAdapterConfig", generator="Immutables")
@Immutable
public final class ImmutableAdjustableTxDatabaseAdapterConfig
implements AdjustableTxDatabaseAdapterConfig {
    private final String repositoryId;
    private final int parentsPerCommit;
    private final int keyListDistance;
    private final int maxKeyListSize;
    private final int maxKeyListEntitySize;
    private final float keyListHashLoadFactor;
    private final int keyListEntityPrefetch;
    private final long commitTimeout;
    private final int commitRetries;
    private final long retryInitialSleepMillisLower;
    private final long retryInitialSleepMillisUpper;
    private final long retryMaxSleepMillis;
    private final Clock clock;
    private final int parentsPerRefLogEntry;
    private final long assumedWallClockDriftMicros;
    private final int attachmentKeysBatchSize;
    private final int batchSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAdjustableTxDatabaseAdapterConfig(Builder builder) {
        if (builder.repositoryId != null) {
            this.initShim.repositoryId(builder.repositoryId);
        }
        if (builder.parentsPerCommitIsSet()) {
            this.initShim.parentsPerCommit(builder.parentsPerCommit);
        }
        if (builder.keyListDistanceIsSet()) {
            this.initShim.keyListDistance(builder.keyListDistance);
        }
        if (builder.maxKeyListSizeIsSet()) {
            this.initShim.maxKeyListSize(builder.maxKeyListSize);
        }
        if (builder.maxKeyListEntitySizeIsSet()) {
            this.initShim.maxKeyListEntitySize(builder.maxKeyListEntitySize);
        }
        if (builder.keyListHashLoadFactorIsSet()) {
            this.initShim.keyListHashLoadFactor(builder.keyListHashLoadFactor);
        }
        if (builder.keyListEntityPrefetchIsSet()) {
            this.initShim.keyListEntityPrefetch(builder.keyListEntityPrefetch);
        }
        if (builder.commitTimeoutIsSet()) {
            this.initShim.commitTimeout(builder.commitTimeout);
        }
        if (builder.commitRetriesIsSet()) {
            this.initShim.commitRetries(builder.commitRetries);
        }
        if (builder.retryInitialSleepMillisLowerIsSet()) {
            this.initShim.retryInitialSleepMillisLower(builder.retryInitialSleepMillisLower);
        }
        if (builder.retryInitialSleepMillisUpperIsSet()) {
            this.initShim.retryInitialSleepMillisUpper(builder.retryInitialSleepMillisUpper);
        }
        if (builder.retryMaxSleepMillisIsSet()) {
            this.initShim.retryMaxSleepMillis(builder.retryMaxSleepMillis);
        }
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        if (builder.parentsPerRefLogEntryIsSet()) {
            this.initShim.parentsPerRefLogEntry(builder.parentsPerRefLogEntry);
        }
        if (builder.assumedWallClockDriftMicrosIsSet()) {
            this.initShim.assumedWallClockDriftMicros(builder.assumedWallClockDriftMicros);
        }
        if (builder.attachmentKeysBatchSizeIsSet()) {
            this.initShim.attachmentKeysBatchSize(builder.attachmentKeysBatchSize);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        this.repositoryId = this.initShim.getRepositoryId();
        this.parentsPerCommit = this.initShim.getParentsPerCommit();
        this.keyListDistance = this.initShim.getKeyListDistance();
        this.maxKeyListSize = this.initShim.getMaxKeyListSize();
        this.maxKeyListEntitySize = this.initShim.getMaxKeyListEntitySize();
        this.keyListHashLoadFactor = this.initShim.getKeyListHashLoadFactor();
        this.keyListEntityPrefetch = this.initShim.getKeyListEntityPrefetch();
        this.commitTimeout = this.initShim.getCommitTimeout();
        this.commitRetries = this.initShim.getCommitRetries();
        this.retryInitialSleepMillisLower = this.initShim.getRetryInitialSleepMillisLower();
        this.retryInitialSleepMillisUpper = this.initShim.getRetryInitialSleepMillisUpper();
        this.retryMaxSleepMillis = this.initShim.getRetryMaxSleepMillis();
        this.clock = this.initShim.getClock();
        this.parentsPerRefLogEntry = this.initShim.getParentsPerRefLogEntry();
        this.assumedWallClockDriftMicros = this.initShim.getAssumedWallClockDriftMicros();
        this.attachmentKeysBatchSize = this.initShim.getAttachmentKeysBatchSize();
        this.batchSize = this.initShim.getBatchSize();
        this.initShim = null;
    }

    private ImmutableAdjustableTxDatabaseAdapterConfig(String repositoryId, int parentsPerCommit, int keyListDistance, int maxKeyListSize, int maxKeyListEntitySize, float keyListHashLoadFactor, int keyListEntityPrefetch, long commitTimeout, int commitRetries, long retryInitialSleepMillisLower, long retryInitialSleepMillisUpper, long retryMaxSleepMillis, Clock clock, int parentsPerRefLogEntry, long assumedWallClockDriftMicros, int attachmentKeysBatchSize, int batchSize) {
        this.repositoryId = repositoryId;
        this.parentsPerCommit = parentsPerCommit;
        this.keyListDistance = keyListDistance;
        this.maxKeyListSize = maxKeyListSize;
        this.maxKeyListEntitySize = maxKeyListEntitySize;
        this.keyListHashLoadFactor = keyListHashLoadFactor;
        this.keyListEntityPrefetch = keyListEntityPrefetch;
        this.commitTimeout = commitTimeout;
        this.commitRetries = commitRetries;
        this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
        this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
        this.retryMaxSleepMillis = retryMaxSleepMillis;
        this.clock = clock;
        this.parentsPerRefLogEntry = parentsPerRefLogEntry;
        this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
        this.attachmentKeysBatchSize = attachmentKeysBatchSize;
        this.batchSize = batchSize;
        this.initShim = null;
    }

    private String getRepositoryIdInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getRepositoryId();
    }

    private int getParentsPerCommitInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getParentsPerCommit();
    }

    private int getKeyListDistanceInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getKeyListDistance();
    }

    private int getMaxKeyListSizeInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getMaxKeyListSize();
    }

    private int getMaxKeyListEntitySizeInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getMaxKeyListEntitySize();
    }

    private float getKeyListHashLoadFactorInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getKeyListHashLoadFactor();
    }

    private int getKeyListEntityPrefetchInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getKeyListEntityPrefetch();
    }

    private long getCommitTimeoutInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getCommitTimeout();
    }

    private int getCommitRetriesInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getCommitRetries();
    }

    private long getRetryInitialSleepMillisLowerInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getRetryInitialSleepMillisLower();
    }

    private long getRetryInitialSleepMillisUpperInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getRetryInitialSleepMillisUpper();
    }

    private long getRetryMaxSleepMillisInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getRetryMaxSleepMillis();
    }

    private Clock getClockInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getClock();
    }

    private int getParentsPerRefLogEntryInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getParentsPerRefLogEntry();
    }

    private long getAssumedWallClockDriftMicrosInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getAssumedWallClockDriftMicros();
    }

    private int getAttachmentKeysBatchSizeInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getAttachmentKeysBatchSize();
    }

    private int getBatchSizeInitialize() {
        return AdjustableTxDatabaseAdapterConfig.super.getBatchSize();
    }

    public String getRepositoryId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRepositoryId() : this.repositoryId;
    }

    public int getParentsPerCommit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParentsPerCommit() : this.parentsPerCommit;
    }

    public int getKeyListDistance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKeyListDistance() : this.keyListDistance;
    }

    public int getMaxKeyListSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxKeyListSize() : this.maxKeyListSize;
    }

    public int getMaxKeyListEntitySize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxKeyListEntitySize() : this.maxKeyListEntitySize;
    }

    public float getKeyListHashLoadFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKeyListHashLoadFactor() : this.keyListHashLoadFactor;
    }

    public int getKeyListEntityPrefetch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKeyListEntityPrefetch() : this.keyListEntityPrefetch;
    }

    public long getCommitTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitTimeout() : this.commitTimeout;
    }

    public int getCommitRetries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitRetries() : this.commitRetries;
    }

    public long getRetryInitialSleepMillisLower() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRetryInitialSleepMillisLower() : this.retryInitialSleepMillisLower;
    }

    public long getRetryInitialSleepMillisUpper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRetryInitialSleepMillisUpper() : this.retryInitialSleepMillisUpper;
    }

    public long getRetryMaxSleepMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRetryMaxSleepMillis() : this.retryMaxSleepMillis;
    }

    public Clock getClock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClock() : this.clock;
    }

    public int getParentsPerRefLogEntry() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParentsPerRefLogEntry() : this.parentsPerRefLogEntry;
    }

    public long getAssumedWallClockDriftMicros() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAssumedWallClockDriftMicros() : this.assumedWallClockDriftMicros;
    }

    public int getAttachmentKeysBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttachmentKeysBatchSize() : this.attachmentKeysBatchSize;
    }

    @Override
    public int getBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBatchSize() : this.batchSize;
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withRepositoryId(String value) {
        String newValue = Objects.requireNonNull(value, "repositoryId");
        if (this.repositoryId.equals(newValue)) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(newValue, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withParentsPerCommit(int value) {
        if (this.parentsPerCommit == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, value, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withKeyListDistance(int value) {
        if (this.keyListDistance == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, value, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withMaxKeyListSize(int value) {
        if (this.maxKeyListSize == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, value, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withMaxKeyListEntitySize(int value) {
        if (this.maxKeyListEntitySize == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, value, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withKeyListHashLoadFactor(float value) {
        if (Float.floatToIntBits(this.keyListHashLoadFactor) == Float.floatToIntBits(value)) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, value, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withKeyListEntityPrefetch(int value) {
        if (this.keyListEntityPrefetch == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, value, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withCommitTimeout(long value) {
        if (this.commitTimeout == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, value, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withCommitRetries(int value) {
        if (this.commitRetries == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, value, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withRetryInitialSleepMillisLower(long value) {
        if (this.retryInitialSleepMillisLower == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, value, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withRetryInitialSleepMillisUpper(long value) {
        if (this.retryInitialSleepMillisUpper == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, value, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withRetryMaxSleepMillis(long value) {
        if (this.retryMaxSleepMillis == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, value, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, newValue, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withParentsPerRefLogEntry(int value) {
        if (this.parentsPerRefLogEntry == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, value, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withAssumedWallClockDriftMicros(long value) {
        if (this.assumedWallClockDriftMicros == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, value, this.attachmentKeysBatchSize, this.batchSize);
    }

    public final ImmutableAdjustableTxDatabaseAdapterConfig withAttachmentKeysBatchSize(int value) {
        if (this.attachmentKeysBatchSize == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, value, this.batchSize);
    }

    @Override
    public final ImmutableAdjustableTxDatabaseAdapterConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return new ImmutableAdjustableTxDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.maxKeyListEntitySize, this.keyListHashLoadFactor, this.keyListEntityPrefetch, this.commitTimeout, this.commitRetries, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.clock, this.parentsPerRefLogEntry, this.assumedWallClockDriftMicros, this.attachmentKeysBatchSize, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdjustableTxDatabaseAdapterConfig && this.equalTo(0, (ImmutableAdjustableTxDatabaseAdapterConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdjustableTxDatabaseAdapterConfig another) {
        return this.repositoryId.equals(another.repositoryId) && this.parentsPerCommit == another.parentsPerCommit && this.keyListDistance == another.keyListDistance && this.maxKeyListSize == another.maxKeyListSize && this.maxKeyListEntitySize == another.maxKeyListEntitySize && Float.floatToIntBits(this.keyListHashLoadFactor) == Float.floatToIntBits(another.keyListHashLoadFactor) && this.keyListEntityPrefetch == another.keyListEntityPrefetch && this.commitTimeout == another.commitTimeout && this.commitRetries == another.commitRetries && this.retryInitialSleepMillisLower == another.retryInitialSleepMillisLower && this.retryInitialSleepMillisUpper == another.retryInitialSleepMillisUpper && this.retryMaxSleepMillis == another.retryMaxSleepMillis && this.clock.equals(another.clock) && this.parentsPerRefLogEntry == another.parentsPerRefLogEntry && this.assumedWallClockDriftMicros == another.assumedWallClockDriftMicros && this.attachmentKeysBatchSize == another.attachmentKeysBatchSize && this.batchSize == another.batchSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repositoryId.hashCode();
        h += (h << 5) + this.parentsPerCommit;
        h += (h << 5) + this.keyListDistance;
        h += (h << 5) + this.maxKeyListSize;
        h += (h << 5) + this.maxKeyListEntitySize;
        h += (h << 5) + Floats.hashCode((float)this.keyListHashLoadFactor);
        h += (h << 5) + this.keyListEntityPrefetch;
        h += (h << 5) + Longs.hashCode((long)this.commitTimeout);
        h += (h << 5) + this.commitRetries;
        h += (h << 5) + Longs.hashCode((long)this.retryInitialSleepMillisLower);
        h += (h << 5) + Longs.hashCode((long)this.retryInitialSleepMillisUpper);
        h += (h << 5) + Longs.hashCode((long)this.retryMaxSleepMillis);
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + this.parentsPerRefLogEntry;
        h += (h << 5) + Longs.hashCode((long)this.assumedWallClockDriftMicros);
        h += (h << 5) + this.attachmentKeysBatchSize;
        h += (h << 5) + this.batchSize;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AdjustableTxDatabaseAdapterConfig").omitNullValues().add("repositoryId", (Object)this.repositoryId).add("parentsPerCommit", this.parentsPerCommit).add("keyListDistance", this.keyListDistance).add("maxKeyListSize", this.maxKeyListSize).add("maxKeyListEntitySize", this.maxKeyListEntitySize).add("keyListHashLoadFactor", this.keyListHashLoadFactor).add("keyListEntityPrefetch", this.keyListEntityPrefetch).add("commitTimeout", this.commitTimeout).add("commitRetries", this.commitRetries).add("retryInitialSleepMillisLower", this.retryInitialSleepMillisLower).add("retryInitialSleepMillisUpper", this.retryInitialSleepMillisUpper).add("retryMaxSleepMillis", this.retryMaxSleepMillis).add("clock", (Object)this.clock).add("parentsPerRefLogEntry", this.parentsPerRefLogEntry).add("assumedWallClockDriftMicros", this.assumedWallClockDriftMicros).add("attachmentKeysBatchSize", this.attachmentKeysBatchSize).add("batchSize", this.batchSize).toString();
    }

    public static ImmutableAdjustableTxDatabaseAdapterConfig copyOf(AdjustableTxDatabaseAdapterConfig instance) {
        if (instance instanceof ImmutableAdjustableTxDatabaseAdapterConfig) {
            return (ImmutableAdjustableTxDatabaseAdapterConfig)instance;
        }
        return ImmutableAdjustableTxDatabaseAdapterConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdjustableTxDatabaseAdapterConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PARENTS_PER_COMMIT = 1L;
        private static final long OPT_BIT_KEY_LIST_DISTANCE = 2L;
        private static final long OPT_BIT_MAX_KEY_LIST_SIZE = 4L;
        private static final long OPT_BIT_MAX_KEY_LIST_ENTITY_SIZE = 8L;
        private static final long OPT_BIT_KEY_LIST_HASH_LOAD_FACTOR = 16L;
        private static final long OPT_BIT_KEY_LIST_ENTITY_PREFETCH = 32L;
        private static final long OPT_BIT_COMMIT_TIMEOUT = 64L;
        private static final long OPT_BIT_COMMIT_RETRIES = 128L;
        private static final long OPT_BIT_RETRY_INITIAL_SLEEP_MILLIS_LOWER = 256L;
        private static final long OPT_BIT_RETRY_INITIAL_SLEEP_MILLIS_UPPER = 512L;
        private static final long OPT_BIT_RETRY_MAX_SLEEP_MILLIS = 1024L;
        private static final long OPT_BIT_PARENTS_PER_REF_LOG_ENTRY = 2048L;
        private static final long OPT_BIT_ASSUMED_WALL_CLOCK_DRIFT_MICROS = 4096L;
        private static final long OPT_BIT_ATTACHMENT_KEYS_BATCH_SIZE = 8192L;
        private static final long OPT_BIT_BATCH_SIZE = 16384L;
        private long optBits;
        @Nullable
        private String repositoryId;
        private int parentsPerCommit;
        private int keyListDistance;
        private int maxKeyListSize;
        private int maxKeyListEntitySize;
        private float keyListHashLoadFactor;
        private int keyListEntityPrefetch;
        private long commitTimeout;
        private int commitRetries;
        private long retryInitialSleepMillisLower;
        private long retryInitialSleepMillisUpper;
        private long retryMaxSleepMillis;
        @Nullable
        private Clock clock;
        private int parentsPerRefLogEntry;
        private long assumedWallClockDriftMicros;
        private int attachmentKeysBatchSize;
        private int batchSize;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AdjustableTxDatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdjustableDatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TxDatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TxDatabaseAdapterConfig instance;
            long bits = 0L;
            if (object instanceof AdjustableTxDatabaseAdapterConfig) {
                instance = (AdjustableTxDatabaseAdapterConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxKeyListSize(instance.getMaxKeyListSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.getRetryInitialSleepMillisUpper());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryMaxSleepMillis(instance.getRetryMaxSleepMillis());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.getRetryInitialSleepMillisLower());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keyListDistance(instance.getKeyListDistance());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.getAssumedWallClockDriftMicros());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.parentsPerCommit(instance.getParentsPerCommit());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.clock(instance.getClock());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.keyListHashLoadFactor(instance.getKeyListHashLoadFactor());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.commitRetries(instance.getCommitRetries());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.parentsPerRefLogEntry(instance.getParentsPerRefLogEntry());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxKeyListEntitySize(instance.getMaxKeyListEntitySize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.commitTimeout(instance.getCommitTimeout());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.repositoryId(instance.getRepositoryId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.attachmentKeysBatchSize(instance.getAttachmentKeysBatchSize());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.batchSize(instance.getBatchSize());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.keyListEntityPrefetch(instance.getKeyListEntityPrefetch());
                    bits |= 0x10000L;
                }
            }
            if (object instanceof AdjustableDatabaseAdapterConfig) {
                instance = (AdjustableDatabaseAdapterConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxKeyListSize(instance.getMaxKeyListSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.getRetryInitialSleepMillisUpper());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryMaxSleepMillis(instance.getRetryMaxSleepMillis());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.getRetryInitialSleepMillisLower());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keyListDistance(instance.getKeyListDistance());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.getAssumedWallClockDriftMicros());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.parentsPerCommit(instance.getParentsPerCommit());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.clock(instance.getClock());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.keyListHashLoadFactor(instance.getKeyListHashLoadFactor());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.commitRetries(instance.getCommitRetries());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.parentsPerRefLogEntry(instance.getParentsPerRefLogEntry());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxKeyListEntitySize(instance.getMaxKeyListEntitySize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.commitTimeout(instance.getCommitTimeout());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.repositoryId(instance.getRepositoryId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.attachmentKeysBatchSize(instance.getAttachmentKeysBatchSize());
                    bits |= 0x4000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.keyListEntityPrefetch(instance.getKeyListEntityPrefetch());
                    bits |= 0x10000L;
                }
            }
            if (object instanceof TxDatabaseAdapterConfig) {
                instance = (TxDatabaseAdapterConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxKeyListSize(instance.getMaxKeyListSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.getRetryInitialSleepMillisUpper());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryMaxSleepMillis(instance.getRetryMaxSleepMillis());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.getRetryInitialSleepMillisLower());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keyListDistance(instance.getKeyListDistance());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.getAssumedWallClockDriftMicros());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.parentsPerCommit(instance.getParentsPerCommit());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.clock(instance.getClock());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.keyListHashLoadFactor(instance.getKeyListHashLoadFactor());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.commitRetries(instance.getCommitRetries());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.parentsPerRefLogEntry(instance.getParentsPerRefLogEntry());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxKeyListEntitySize(instance.getMaxKeyListEntitySize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.commitTimeout(instance.getCommitTimeout());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.repositoryId(instance.getRepositoryId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.attachmentKeysBatchSize(instance.getAttachmentKeysBatchSize());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.batchSize(instance.getBatchSize());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.keyListEntityPrefetch(instance.getKeyListEntityPrefetch());
                    bits |= 0x10000L;
                }
            }
            if (object instanceof DatabaseAdapterConfig) {
                instance = (DatabaseAdapterConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxKeyListSize(instance.getMaxKeyListSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.getRetryInitialSleepMillisUpper());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryMaxSleepMillis(instance.getRetryMaxSleepMillis());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.getRetryInitialSleepMillisLower());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keyListDistance(instance.getKeyListDistance());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.getAssumedWallClockDriftMicros());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.parentsPerCommit(instance.getParentsPerCommit());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.clock(instance.getClock());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.keyListHashLoadFactor(instance.getKeyListHashLoadFactor());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.commitRetries(instance.getCommitRetries());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.parentsPerRefLogEntry(instance.getParentsPerRefLogEntry());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxKeyListEntitySize(instance.getMaxKeyListEntitySize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.commitTimeout(instance.getCommitTimeout());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.repositoryId(instance.getRepositoryId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.attachmentKeysBatchSize(instance.getAttachmentKeysBatchSize());
                    bits |= 0x4000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.keyListEntityPrefetch(instance.getKeyListEntityPrefetch());
                    bits |= 0x10000L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxKeyListSize(int maxKeyListSize) {
            this.maxKeyListSize = maxKeyListSize;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxKeyListEntitySize(int maxKeyListEntitySize) {
            this.maxKeyListEntitySize = maxKeyListEntitySize;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListHashLoadFactor(float keyListHashLoadFactor) {
            this.keyListHashLoadFactor = keyListHashLoadFactor;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListEntityPrefetch(int keyListEntityPrefetch) {
            this.keyListEntityPrefetch = keyListEntityPrefetch;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitTimeout(long commitTimeout) {
            this.commitTimeout = commitTimeout;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryInitialSleepMillisLower(long retryInitialSleepMillisLower) {
            this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryInitialSleepMillisUpper(long retryInitialSleepMillisUpper) {
            this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryMaxSleepMillis(long retryMaxSleepMillis) {
            this.retryMaxSleepMillis = retryMaxSleepMillis;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentsPerRefLogEntry(int parentsPerRefLogEntry) {
            this.parentsPerRefLogEntry = parentsPerRefLogEntry;
            this.optBits |= 0x800L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assumedWallClockDriftMicros(long assumedWallClockDriftMicros) {
            this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
            this.optBits |= 0x1000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attachmentKeysBatchSize(int attachmentKeysBatchSize) {
            this.attachmentKeysBatchSize = attachmentKeysBatchSize;
            this.optBits |= 0x2000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x4000L;
            return this;
        }

        public ImmutableAdjustableTxDatabaseAdapterConfig build() {
            return new ImmutableAdjustableTxDatabaseAdapterConfig(this);
        }

        private boolean parentsPerCommitIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keyListDistanceIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxKeyListSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean maxKeyListEntitySizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean keyListHashLoadFactorIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean keyListEntityPrefetchIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean commitTimeoutIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean commitRetriesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean retryInitialSleepMillisLowerIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean retryInitialSleepMillisUpperIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean retryMaxSleepMillisIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean parentsPerRefLogEntryIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean assumedWallClockDriftMicrosIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean attachmentKeysBatchSizeIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }
    }

    @Generated(from="AdjustableTxDatabaseAdapterConfig", generator="Immutables")
    private final class InitShim {
        private byte repositoryIdBuildStage = 0;
        private String repositoryId;
        private byte parentsPerCommitBuildStage = 0;
        private int parentsPerCommit;
        private byte keyListDistanceBuildStage = 0;
        private int keyListDistance;
        private byte maxKeyListSizeBuildStage = 0;
        private int maxKeyListSize;
        private byte maxKeyListEntitySizeBuildStage = 0;
        private int maxKeyListEntitySize;
        private byte keyListHashLoadFactorBuildStage = 0;
        private float keyListHashLoadFactor;
        private byte keyListEntityPrefetchBuildStage = 0;
        private int keyListEntityPrefetch;
        private byte commitTimeoutBuildStage = 0;
        private long commitTimeout;
        private byte commitRetriesBuildStage = 0;
        private int commitRetries;
        private byte retryInitialSleepMillisLowerBuildStage = 0;
        private long retryInitialSleepMillisLower;
        private byte retryInitialSleepMillisUpperBuildStage = 0;
        private long retryInitialSleepMillisUpper;
        private byte retryMaxSleepMillisBuildStage = 0;
        private long retryMaxSleepMillis;
        private byte clockBuildStage = 0;
        private Clock clock;
        private byte parentsPerRefLogEntryBuildStage = 0;
        private int parentsPerRefLogEntry;
        private byte assumedWallClockDriftMicrosBuildStage = 0;
        private long assumedWallClockDriftMicros;
        private byte attachmentKeysBatchSizeBuildStage = 0;
        private int attachmentKeysBatchSize;
        private byte batchSizeBuildStage = 0;
        private int batchSize;

        private InitShim() {
        }

        String getRepositoryId() {
            if (this.repositoryIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repositoryIdBuildStage == 0) {
                this.repositoryIdBuildStage = (byte)-1;
                this.repositoryId = Objects.requireNonNull(ImmutableAdjustableTxDatabaseAdapterConfig.this.getRepositoryIdInitialize(), "repositoryId");
                this.repositoryIdBuildStage = 1;
            }
            return this.repositoryId;
        }

        void repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.repositoryIdBuildStage = 1;
        }

        int getParentsPerCommit() {
            if (this.parentsPerCommitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentsPerCommitBuildStage == 0) {
                this.parentsPerCommitBuildStage = (byte)-1;
                this.parentsPerCommit = ImmutableAdjustableTxDatabaseAdapterConfig.this.getParentsPerCommitInitialize();
                this.parentsPerCommitBuildStage = 1;
            }
            return this.parentsPerCommit;
        }

        void parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.parentsPerCommitBuildStage = 1;
        }

        int getKeyListDistance() {
            if (this.keyListDistanceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyListDistanceBuildStage == 0) {
                this.keyListDistanceBuildStage = (byte)-1;
                this.keyListDistance = ImmutableAdjustableTxDatabaseAdapterConfig.this.getKeyListDistanceInitialize();
                this.keyListDistanceBuildStage = 1;
            }
            return this.keyListDistance;
        }

        void keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.keyListDistanceBuildStage = 1;
        }

        int getMaxKeyListSize() {
            if (this.maxKeyListSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxKeyListSizeBuildStage == 0) {
                this.maxKeyListSizeBuildStage = (byte)-1;
                this.maxKeyListSize = ImmutableAdjustableTxDatabaseAdapterConfig.this.getMaxKeyListSizeInitialize();
                this.maxKeyListSizeBuildStage = 1;
            }
            return this.maxKeyListSize;
        }

        void maxKeyListSize(int maxKeyListSize) {
            this.maxKeyListSize = maxKeyListSize;
            this.maxKeyListSizeBuildStage = 1;
        }

        int getMaxKeyListEntitySize() {
            if (this.maxKeyListEntitySizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxKeyListEntitySizeBuildStage == 0) {
                this.maxKeyListEntitySizeBuildStage = (byte)-1;
                this.maxKeyListEntitySize = ImmutableAdjustableTxDatabaseAdapterConfig.this.getMaxKeyListEntitySizeInitialize();
                this.maxKeyListEntitySizeBuildStage = 1;
            }
            return this.maxKeyListEntitySize;
        }

        void maxKeyListEntitySize(int maxKeyListEntitySize) {
            this.maxKeyListEntitySize = maxKeyListEntitySize;
            this.maxKeyListEntitySizeBuildStage = 1;
        }

        float getKeyListHashLoadFactor() {
            if (this.keyListHashLoadFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyListHashLoadFactorBuildStage == 0) {
                this.keyListHashLoadFactorBuildStage = (byte)-1;
                this.keyListHashLoadFactor = ImmutableAdjustableTxDatabaseAdapterConfig.this.getKeyListHashLoadFactorInitialize();
                this.keyListHashLoadFactorBuildStage = 1;
            }
            return this.keyListHashLoadFactor;
        }

        void keyListHashLoadFactor(float keyListHashLoadFactor) {
            this.keyListHashLoadFactor = keyListHashLoadFactor;
            this.keyListHashLoadFactorBuildStage = 1;
        }

        int getKeyListEntityPrefetch() {
            if (this.keyListEntityPrefetchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyListEntityPrefetchBuildStage == 0) {
                this.keyListEntityPrefetchBuildStage = (byte)-1;
                this.keyListEntityPrefetch = ImmutableAdjustableTxDatabaseAdapterConfig.this.getKeyListEntityPrefetchInitialize();
                this.keyListEntityPrefetchBuildStage = 1;
            }
            return this.keyListEntityPrefetch;
        }

        void keyListEntityPrefetch(int keyListEntityPrefetch) {
            this.keyListEntityPrefetch = keyListEntityPrefetch;
            this.keyListEntityPrefetchBuildStage = 1;
        }

        long getCommitTimeout() {
            if (this.commitTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitTimeoutBuildStage == 0) {
                this.commitTimeoutBuildStage = (byte)-1;
                this.commitTimeout = ImmutableAdjustableTxDatabaseAdapterConfig.this.getCommitTimeoutInitialize();
                this.commitTimeoutBuildStage = 1;
            }
            return this.commitTimeout;
        }

        void commitTimeout(long commitTimeout) {
            this.commitTimeout = commitTimeout;
            this.commitTimeoutBuildStage = 1;
        }

        int getCommitRetries() {
            if (this.commitRetriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitRetriesBuildStage == 0) {
                this.commitRetriesBuildStage = (byte)-1;
                this.commitRetries = ImmutableAdjustableTxDatabaseAdapterConfig.this.getCommitRetriesInitialize();
                this.commitRetriesBuildStage = 1;
            }
            return this.commitRetries;
        }

        void commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.commitRetriesBuildStage = 1;
        }

        long getRetryInitialSleepMillisLower() {
            if (this.retryInitialSleepMillisLowerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryInitialSleepMillisLowerBuildStage == 0) {
                this.retryInitialSleepMillisLowerBuildStage = (byte)-1;
                this.retryInitialSleepMillisLower = ImmutableAdjustableTxDatabaseAdapterConfig.this.getRetryInitialSleepMillisLowerInitialize();
                this.retryInitialSleepMillisLowerBuildStage = 1;
            }
            return this.retryInitialSleepMillisLower;
        }

        void retryInitialSleepMillisLower(long retryInitialSleepMillisLower) {
            this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
            this.retryInitialSleepMillisLowerBuildStage = 1;
        }

        long getRetryInitialSleepMillisUpper() {
            if (this.retryInitialSleepMillisUpperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryInitialSleepMillisUpperBuildStage == 0) {
                this.retryInitialSleepMillisUpperBuildStage = (byte)-1;
                this.retryInitialSleepMillisUpper = ImmutableAdjustableTxDatabaseAdapterConfig.this.getRetryInitialSleepMillisUpperInitialize();
                this.retryInitialSleepMillisUpperBuildStage = 1;
            }
            return this.retryInitialSleepMillisUpper;
        }

        void retryInitialSleepMillisUpper(long retryInitialSleepMillisUpper) {
            this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
            this.retryInitialSleepMillisUpperBuildStage = 1;
        }

        long getRetryMaxSleepMillis() {
            if (this.retryMaxSleepMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryMaxSleepMillisBuildStage == 0) {
                this.retryMaxSleepMillisBuildStage = (byte)-1;
                this.retryMaxSleepMillis = ImmutableAdjustableTxDatabaseAdapterConfig.this.getRetryMaxSleepMillisInitialize();
                this.retryMaxSleepMillisBuildStage = 1;
            }
            return this.retryMaxSleepMillis;
        }

        void retryMaxSleepMillis(long retryMaxSleepMillis) {
            this.retryMaxSleepMillis = retryMaxSleepMillis;
            this.retryMaxSleepMillisBuildStage = 1;
        }

        Clock getClock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableAdjustableTxDatabaseAdapterConfig.this.getClockInitialize(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        int getParentsPerRefLogEntry() {
            if (this.parentsPerRefLogEntryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentsPerRefLogEntryBuildStage == 0) {
                this.parentsPerRefLogEntryBuildStage = (byte)-1;
                this.parentsPerRefLogEntry = ImmutableAdjustableTxDatabaseAdapterConfig.this.getParentsPerRefLogEntryInitialize();
                this.parentsPerRefLogEntryBuildStage = 1;
            }
            return this.parentsPerRefLogEntry;
        }

        void parentsPerRefLogEntry(int parentsPerRefLogEntry) {
            this.parentsPerRefLogEntry = parentsPerRefLogEntry;
            this.parentsPerRefLogEntryBuildStage = 1;
        }

        long getAssumedWallClockDriftMicros() {
            if (this.assumedWallClockDriftMicrosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assumedWallClockDriftMicrosBuildStage == 0) {
                this.assumedWallClockDriftMicrosBuildStage = (byte)-1;
                this.assumedWallClockDriftMicros = ImmutableAdjustableTxDatabaseAdapterConfig.this.getAssumedWallClockDriftMicrosInitialize();
                this.assumedWallClockDriftMicrosBuildStage = 1;
            }
            return this.assumedWallClockDriftMicros;
        }

        void assumedWallClockDriftMicros(long assumedWallClockDriftMicros) {
            this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
            this.assumedWallClockDriftMicrosBuildStage = 1;
        }

        int getAttachmentKeysBatchSize() {
            if (this.attachmentKeysBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentKeysBatchSizeBuildStage == 0) {
                this.attachmentKeysBatchSizeBuildStage = (byte)-1;
                this.attachmentKeysBatchSize = ImmutableAdjustableTxDatabaseAdapterConfig.this.getAttachmentKeysBatchSizeInitialize();
                this.attachmentKeysBatchSizeBuildStage = 1;
            }
            return this.attachmentKeysBatchSize;
        }

        void attachmentKeysBatchSize(int attachmentKeysBatchSize) {
            this.attachmentKeysBatchSize = attachmentKeysBatchSize;
            this.attachmentKeysBatchSizeBuildStage = 1;
        }

        int getBatchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableAdjustableTxDatabaseAdapterConfig.this.getBatchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.repositoryIdBuildStage == -1) {
                attributes.add("repositoryId");
            }
            if (this.parentsPerCommitBuildStage == -1) {
                attributes.add("parentsPerCommit");
            }
            if (this.keyListDistanceBuildStage == -1) {
                attributes.add("keyListDistance");
            }
            if (this.maxKeyListSizeBuildStage == -1) {
                attributes.add("maxKeyListSize");
            }
            if (this.maxKeyListEntitySizeBuildStage == -1) {
                attributes.add("maxKeyListEntitySize");
            }
            if (this.keyListHashLoadFactorBuildStage == -1) {
                attributes.add("keyListHashLoadFactor");
            }
            if (this.keyListEntityPrefetchBuildStage == -1) {
                attributes.add("keyListEntityPrefetch");
            }
            if (this.commitTimeoutBuildStage == -1) {
                attributes.add("commitTimeout");
            }
            if (this.commitRetriesBuildStage == -1) {
                attributes.add("commitRetries");
            }
            if (this.retryInitialSleepMillisLowerBuildStage == -1) {
                attributes.add("retryInitialSleepMillisLower");
            }
            if (this.retryInitialSleepMillisUpperBuildStage == -1) {
                attributes.add("retryInitialSleepMillisUpper");
            }
            if (this.retryMaxSleepMillisBuildStage == -1) {
                attributes.add("retryMaxSleepMillis");
            }
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.parentsPerRefLogEntryBuildStage == -1) {
                attributes.add("parentsPerRefLogEntry");
            }
            if (this.assumedWallClockDriftMicrosBuildStage == -1) {
                attributes.add("assumedWallClockDriftMicros");
            }
            if (this.attachmentKeysBatchSizeBuildStage == -1) {
                attributes.add("attachmentKeysBatchSize");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            return "Cannot build AdjustableTxDatabaseAdapterConfig, attribute initializers form cycle " + attributes;
        }
    }
}

