/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class JdbcSelectSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private boolean done = false;
    private final Connection connection;
    private PreparedStatement ps;
    private ResultSet rs;
    private final String sql;
    private final ResultSetMapper<T> deserializer;
    private final PrepareStatement prepareStatement;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    static <T> Stream<T> buildStream(Connection conn, String sql, PrepareStatement prepareStatement, ResultSetMapper<T> deserializer) {
        return super.toStream();
    }

    private JdbcSelectSpliterator(Connection conn, String sql, PrepareStatement prepareStatement, ResultSetMapper<T> deserializer) {
        super(Long.MAX_VALUE, 0);
        this.connection = conn;
        this.sql = sql;
        this.prepareStatement = prepareStatement;
        this.deserializer = deserializer;
    }

    private Stream<T> toStream() {
        return (Stream)StreamSupport.stream(this, false).onClose(this::closeResources);
    }

    private void closeResources() {
        Exception e = null;
        while (!this.closeables.isEmpty()) {
            AutoCloseable closeable = this.closeables.remove(this.closeables.size() - 1);
            try {
                closeable.close();
            }
            catch (Exception ex) {
                if (e == null) {
                    e = ex;
                    continue;
                }
                e.addSuppressed(ex);
            }
        }
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean tryAdvance(Consumer<? super T> consumer) {
        if (this.done) {
            return false;
        }
        try {
            if (this.ps == null) {
                this.ps = this.connection.prepareStatement(this.sql);
                this.closeables.add(this.ps);
                this.prepareStatement.accept(this.ps);
                this.rs = this.ps.executeQuery();
                this.closeables.add(this.rs);
            }
            if (!this.rs.next()) {
                this.done = true;
                this.closeResources();
                return false;
            }
            consumer.accept(this.deserializer.apply(this.rs));
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    static interface PrepareStatement {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    @FunctionalInterface
    static interface ResultSetMapper<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

