/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import javax.validation.constraints.NotBlank;
import org.immutables.value.Value;
import org.projectnessie.versioned.ImmutableContentAttachmentKey;

@Value.Immutable
public interface ContentAttachmentKey {
    @NotBlank
    public String getContentId();

    @NotBlank
    public String getAttachmentType();

    @NotBlank
    public String getAttachmentId();

    @Value.Check
    default public void check() {
        Preconditions.checkState((this.getContentId().indexOf(58) == -1 && this.getAttachmentType().indexOf(58) == -1 && this.getAttachmentId().indexOf(58) == -1 ? 1 : 0) != 0, (String)"Elements of ContentAttachmentKey must not contain ':' characters, content-id='%s', object-type=':', object-ID='%s'", (Object)this.getContentId(), (Object)this.getAttachmentType(), (Object)this.getAttachmentId());
    }

    public static ImmutableContentAttachmentKey.Builder builder() {
        return ImmutableContentAttachmentKey.builder();
    }

    public static ContentAttachmentKey of(String contentId, String attachmentType, String attachmentId) {
        return ContentAttachmentKey.builder().contentId(contentId).attachmentType(attachmentType).attachmentId(attachmentId).build();
    }

    default public String asString() {
        return ContentAttachmentKey.keyPartsAsString(this.getContentId(), this.getAttachmentType(), this.getAttachmentId());
    }

    public static String keyPartsAsString(String contentId, String objectType, String objectId) {
        Preconditions.checkState((!contentId.contains("::") && !objectType.contains("::") && !objectId.contains("::") ? 1 : 0) != 0, (Object)"Attributes of an attachment key must not contain '::'");
        return contentId + "::" + objectType + "::" + objectId;
    }
}

