/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyEntry", generator="Immutables")
@Immutable
public final class ImmutableKeyEntry
implements KeyEntry {
    private final Content.Type type;
    private final Key key;
    private final String contentId;

    private ImmutableKeyEntry(Content.Type type, Key key, String contentId) {
        this.type = type;
        this.key = key;
        this.contentId = contentId;
    }

    @Override
    public Content.Type getType() {
        return this.type;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    public final ImmutableKeyEntry withType(Content.Type value) {
        if (this.type == value) {
            return this;
        }
        Content.Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableKeyEntry(newValue, this.key, this.contentId);
    }

    public final ImmutableKeyEntry withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyEntry(this.type, newValue, this.contentId);
    }

    public final ImmutableKeyEntry withContentId(String value) {
        String newValue = Objects.requireNonNull(value, "contentId");
        if (this.contentId.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyEntry(this.type, this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyEntry && this.equalTo(0, (ImmutableKeyEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyEntry another) {
        return this.type.equals(another.type) && this.key.equals(another.key) && this.contentId.equals(another.contentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contentId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyEntry").omitNullValues().add("type", (Object)this.type).add("key", (Object)this.key).add("contentId", (Object)this.contentId).toString();
    }

    public static ImmutableKeyEntry copyOf(KeyEntry instance) {
        if (instance instanceof ImmutableKeyEntry) {
            return (ImmutableKeyEntry)instance;
        }
        return ImmutableKeyEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private static final long INIT_BIT_CONTENT_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private Content.Type type;
        @Nullable
        private Key key;
        @Nullable
        private String contentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.key(instance.getKey());
            this.contentId(instance.getContentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Content.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableKeyEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyEntry(this.type, this.key, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("contentId");
            }
            return "Cannot build KeyEntry, some of required attributes are not set " + attributes;
        }
    }
}

