/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ser.Views;
import org.projectnessie.versioned.Serializer;

public class CommitMetaSerializer
implements Serializer<CommitMeta> {
    public static final Serializer<CommitMeta> METADATA_SERIALIZER = new CommitMetaSerializer();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public ByteString toBytes(CommitMeta value) {
        ByteString byteString;
        block8: {
            ByteString.Output out = ByteString.newOutput();
            try {
                MAPPER.writerWithView(Views.V1.class).writeValue((OutputStream)out, (Object)value);
                byteString = out.toByteString();
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
                }
            }
            out.close();
        }
        return byteString;
    }

    @Override
    public CommitMeta fromBytes(ByteString bytes) {
        CommitMeta commitMeta;
        block8: {
            InputStream in = bytes.newInput();
            try {
                commitMeta = (CommitMeta)MAPPER.readValue(in, CommitMeta.class);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ImmutableCommitMeta.builder().message("unknown").committer("unknown").hash("unknown").build();
                }
            }
            in.close();
        }
        return commitMeta;
    }
}

