/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeResult.KeyDetails", generator="Immutables")
@Immutable
public final class ImmutableKeyDetails
implements MergeResult.KeyDetails {
    private final MergeType mergeType;
    private final MergeResult.ConflictType conflictType;
    private final ImmutableList<Hash> sourceCommits;
    private final ImmutableList<Hash> targetCommits;

    private ImmutableKeyDetails(Builder builder) {
        this.mergeType = builder.mergeType;
        this.sourceCommits = builder.sourceCommits.build();
        this.targetCommits = builder.targetCommits.build();
        this.conflictType = builder.conflictType != null ? builder.conflictType : Objects.requireNonNull(MergeResult.KeyDetails.super.getConflictType(), "conflictType");
    }

    private ImmutableKeyDetails(MergeType mergeType, MergeResult.ConflictType conflictType, ImmutableList<Hash> sourceCommits, ImmutableList<Hash> targetCommits) {
        this.mergeType = mergeType;
        this.conflictType = conflictType;
        this.sourceCommits = sourceCommits;
        this.targetCommits = targetCommits;
    }

    @Override
    public MergeType getMergeType() {
        return this.mergeType;
    }

    @Override
    public MergeResult.ConflictType getConflictType() {
        return this.conflictType;
    }

    @Deprecated
    public ImmutableList<Hash> getSourceCommits() {
        return this.sourceCommits;
    }

    @Deprecated
    public ImmutableList<Hash> getTargetCommits() {
        return this.targetCommits;
    }

    public final ImmutableKeyDetails withMergeType(MergeType value) {
        MergeType newValue = Objects.requireNonNull(value, "mergeType");
        if (this.mergeType == newValue) {
            return this;
        }
        return new ImmutableKeyDetails(newValue, this.conflictType, this.sourceCommits, this.targetCommits);
    }

    public final ImmutableKeyDetails withConflictType(MergeResult.ConflictType value) {
        MergeResult.ConflictType newValue = Objects.requireNonNull(value, "conflictType");
        if (this.conflictType == newValue) {
            return this;
        }
        return new ImmutableKeyDetails(this.mergeType, newValue, this.sourceCommits, this.targetCommits);
    }

    @Deprecated
    public final ImmutableKeyDetails withSourceCommits(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableKeyDetails(this.mergeType, this.conflictType, (ImmutableList<Hash>)newValue, this.targetCommits);
    }

    @Deprecated
    public final ImmutableKeyDetails withSourceCommits(Iterable<? extends Hash> elements) {
        if (this.sourceCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableKeyDetails(this.mergeType, this.conflictType, (ImmutableList<Hash>)newValue, this.targetCommits);
    }

    @Deprecated
    public final ImmutableKeyDetails withTargetCommits(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableKeyDetails(this.mergeType, this.conflictType, this.sourceCommits, (ImmutableList<Hash>)newValue);
    }

    @Deprecated
    public final ImmutableKeyDetails withTargetCommits(Iterable<? extends Hash> elements) {
        if (this.targetCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableKeyDetails(this.mergeType, this.conflictType, this.sourceCommits, (ImmutableList<Hash>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyDetails && this.equalTo(0, (ImmutableKeyDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyDetails another) {
        return this.mergeType.equals((Object)another.mergeType) && this.conflictType.equals((Object)another.conflictType) && this.sourceCommits.equals(another.sourceCommits) && this.targetCommits.equals(another.targetCommits);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mergeType.hashCode();
        h += (h << 5) + this.conflictType.hashCode();
        h += (h << 5) + this.sourceCommits.hashCode();
        h += (h << 5) + this.targetCommits.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyDetails").omitNullValues().add("mergeType", (Object)this.mergeType).add("conflictType", (Object)this.conflictType).add("sourceCommits", this.sourceCommits).add("targetCommits", this.targetCommits).toString();
    }

    public static ImmutableKeyDetails copyOf(MergeResult.KeyDetails instance) {
        if (instance instanceof ImmutableKeyDetails) {
            return (ImmutableKeyDetails)instance;
        }
        return ImmutableKeyDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeResult.KeyDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MERGE_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private MergeType mergeType;
        @Nullable
        private MergeResult.ConflictType conflictType;
        private ImmutableList.Builder<Hash> sourceCommits = ImmutableList.builder();
        private ImmutableList.Builder<Hash> targetCommits = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeResult.KeyDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeType(instance.getMergeType());
            this.conflictType(instance.getConflictType());
            this.addAllSourceCommits(instance.getSourceCommits());
            this.addAllTargetCommits(instance.getTargetCommits());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeType(MergeType mergeType) {
            this.mergeType = Objects.requireNonNull(mergeType, "mergeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder conflictType(MergeResult.ConflictType conflictType) {
            this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addSourceCommits(Hash element) {
            this.sourceCommits.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addSourceCommits(Hash ... elements) {
            this.sourceCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder sourceCommits(Iterable<? extends Hash> elements) {
            this.sourceCommits = ImmutableList.builder();
            return this.addAllSourceCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllSourceCommits(Iterable<? extends Hash> elements) {
            this.sourceCommits.addAll(elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTargetCommits(Hash element) {
            this.targetCommits.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTargetCommits(Hash ... elements) {
            this.targetCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder targetCommits(Iterable<? extends Hash> elements) {
            this.targetCommits = ImmutableList.builder();
            return this.addAllTargetCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllTargetCommits(Iterable<? extends Hash> elements) {
            this.targetCommits.addAll(elements);
            return this;
        }

        public ImmutableKeyDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyDetails(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mergeType");
            }
            return "Cannot build KeyDetails, some of required attributes are not set " + attributes;
        }
    }
}

