/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.errorprone.annotations.MustBeClosed;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;

@ThreadSafe
public interface VersionStore {
    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException;

    @Nonnull
    public Hash noAncestorHash();

    public Hash commit(@Nonnull BranchName var1, @Nonnull Optional<Hash> var2, @Nonnull CommitMeta var3, @Nonnull List<Operation> var4, @Nonnull Callable<Void> var5, @Nonnull BiConsumer<Key, String> var6) throws ReferenceNotFoundException, ReferenceConflictException;

    default public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> referenceHash, @Nonnull CommitMeta metadata, @Nonnull List<Operation> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.commit(branch, referenceHash, metadata, operations, () -> null, (k, c) -> {});
    }

    public MergeResult<Commit> transplant(BranchName var1, Optional<Hash> var2, List<Hash> var3, MetadataRewriter<CommitMeta> var4, boolean var5, Map<Key, MergeType> var6, MergeType var7, boolean var8, boolean var9) throws ReferenceNotFoundException, ReferenceConflictException;

    public MergeResult<Commit> merge(Hash var1, BranchName var2, Optional<Hash> var3, MetadataRewriter<CommitMeta> var4, boolean var5, Map<Key, MergeType> var6, MergeType var7, boolean var8, boolean var9) throws ReferenceNotFoundException, ReferenceConflictException;

    public void assign(NamedRef var1, Optional<Hash> var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Hash create(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceAlreadyExistsException;

    public void delete(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceInfo<CommitMeta> getNamedRef(String var1, GetNamedRefsParams var2) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams var1) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<Commit> getCommits(Ref var1, boolean var2) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<KeyEntry> getKeys(Ref var1) throws ReferenceNotFoundException;

    public Content getValue(Ref var1, Key var2) throws ReferenceNotFoundException;

    public Map<Key, Content> getValues(Ref var1, Collection<Key> var2) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<Diff> getDiffs(Ref var1, Ref var2) throws ReferenceNotFoundException;

    @Deprecated
    @MustBeClosed
    public Stream<RefLogDetails> getRefLog(Hash var1) throws RefLogNotFoundException;
}

