/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Operation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements Commit {
    private final Hash hash;
    private final CommitMeta commitMeta;
    @Nullable
    private final Hash parentHash;
    @Nullable
    private final ImmutableList<Operation> operations;

    private ImmutableCommit(Hash hash, CommitMeta commitMeta, @Nullable Hash parentHash, @Nullable ImmutableList<Operation> operations) {
        this.hash = hash;
        this.commitMeta = commitMeta;
        this.parentHash = parentHash;
        this.operations = operations;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public CommitMeta getCommitMeta() {
        return this.commitMeta;
    }

    @Override
    @Nullable
    public Hash getParentHash() {
        return this.parentHash;
    }

    @Nullable
    public ImmutableList<Operation> getOperations() {
        return this.operations;
    }

    public final ImmutableCommit withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableCommit(newValue, this.commitMeta, this.parentHash, this.operations);
    }

    public final ImmutableCommit withCommitMeta(CommitMeta value) {
        if (this.commitMeta == value) {
            return this;
        }
        CommitMeta newValue = Objects.requireNonNull(value, "commitMeta");
        return new ImmutableCommit(this.hash, newValue, this.parentHash, this.operations);
    }

    public final ImmutableCommit withParentHash(@Nullable Hash value) {
        if (this.parentHash == value) {
            return this;
        }
        return new ImmutableCommit(this.hash, this.commitMeta, value, this.operations);
    }

    public final ImmutableCommit withOperations(Operation ... elements) {
        if (elements == null) {
            return new ImmutableCommit(this.hash, this.commitMeta, this.parentHash, null);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommit(this.hash, this.commitMeta, this.parentHash, (ImmutableList<Operation>)newValue);
    }

    public final ImmutableCommit withOperations(@Nullable Iterable<? extends Operation> elements) {
        if (this.operations == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableCommit(this.hash, this.commitMeta, this.parentHash, (ImmutableList<Operation>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo(0, (ImmutableCommit)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommit another) {
        return this.hash.equals(another.hash) && this.commitMeta.equals(another.commitMeta) && Objects.equals(this.parentHash, another.parentHash) && Objects.equals(this.operations, another.operations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.commitMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentHash);
        h += (h << 5) + Objects.hashCode(this.operations);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Commit").omitNullValues().add("hash", (Object)this.hash).add("commitMeta", (Object)this.commitMeta).add("parentHash", (Object)this.parentHash).add("operations", this.operations).toString();
    }

    public static ImmutableCommit copyOf(Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_COMMIT_META = 2L;
        private long initBits = 3L;
        @Nullable
        private Hash hash;
        @Nullable
        private CommitMeta commitMeta;
        @Nullable
        private Hash parentHash;
        private ImmutableList.Builder<Operation> operations = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Commit instance) {
            List<Operation> operationsValue;
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.getHash());
            this.commitMeta(instance.getCommitMeta());
            Hash parentHashValue = instance.getParentHash();
            if (parentHashValue != null) {
                this.parentHash(parentHashValue);
            }
            if ((operationsValue = instance.getOperations()) != null) {
                this.addAllOperations(operationsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMeta(CommitMeta commitMeta) {
            this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentHash(@Nullable Hash parentHash) {
            this.parentHash = parentHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOperations(Operation element) {
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOperations(Operation ... elements) {
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operations(@Nullable Iterable<? extends Operation> elements) {
            if (elements == null) {
                this.operations = null;
                return this;
            }
            this.operations = ImmutableList.builder();
            return this.addAllOperations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOperations(Iterable<? extends Operation> elements) {
            Objects.requireNonNull(elements, "operations element");
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.addAll(elements);
            return this;
        }

        public ImmutableCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommit(this.hash, this.commitMeta, this.parentHash, this.operations == null ? null : this.operations.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitMeta");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }
}

