/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.versioned.ImmutableKey;

@Value.Immutable
public abstract class Key
implements Comparable<Key> {
    public static final int MAX_LENGTH = 500;
    public static final int MAX_ELEMENTS = 20;

    public abstract List<String> getElements();

    static ImmutableKey.Builder builder() {
        return ImmutableKey.builder();
    }

    @Override
    public final int compareTo(Key that) {
        List<String> a = this.getElements();
        List<String> b = that.getElements();
        int max = Math.min(a.size(), b.size());
        for (int i = 0; i < max; ++i) {
            int cmp = a.get(i).compareTo(b.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return a.size() - b.size();
    }

    public int hashCode() {
        int h = 1;
        for (String element : this.getElements()) {
            h = 31 * h + element.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) {
            return false;
        }
        Key that = (Key)obj;
        List<String> thisElements = this.getElements();
        List<String> thatElements = that.getElements();
        return thisElements.equals(thatElements);
    }

    public static Key of(String ... elements) {
        return ImmutableKey.builder().addElements(elements).build();
    }

    public static Key of(List<String> elements) {
        return ImmutableKey.builder().addAllElements(elements).build();
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((this.getElements().stream().mapToInt(String::length).sum() <= 500 ? 1 : 0) != 0, (String)"Key too long, max allowed length: %s", (int)500);
        Preconditions.checkState((this.getElements().size() <= 20 ? 1 : 0) != 0, (String)"Key too long, max allowed number of elements: %s", (int)20);
    }

    public String toString() {
        return String.join((CharSequence)".", this.getElements());
    }
}

