/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;

public final class MetricsVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private final MeterRegistry registry;
    private final Clock clock;
    private final Iterable<Tag> commonTags;

    MetricsVersionStore(VersionStore delegate, MeterRegistry registry, Clock clock) {
        this.delegate = delegate;
        this.registry = registry;
        this.clock = clock;
        this.commonTags = Tags.of((String)"application", (String)"Nessie");
    }

    public MetricsVersionStore(VersionStore delegate) {
        this(delegate, (MeterRegistry)Metrics.globalRegistry, Clock.SYSTEM);
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.delegate1Ex("hashonreference", () -> this.delegate.hashOnReference(namedReference, hashOnReference));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public Hash commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull Callable<Void> validator, @javax.annotation.Nonnull @Nonnull BiConsumer<Key, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("commit", () -> this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents));
    }

    @Override
    public MergeResult<Commit> transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("transplant", () -> this.delegate.transplant(targetBranch, referenceHash, sequenceToTransplant, updateCommitMetadata, keepIndividualCommits, mergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo));
    }

    @Override
    public MergeResult<Commit> merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("merge", () -> this.delegate.merge(fromHash, toBranch, expectedHash, updateCommitMetadata, keepIndividualCommits, mergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo));
    }

    @Override
    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.delegate2Ex("assign", () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.delegate2ExR("create", () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public Hash delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("delete", () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate1Ex("getnamedref", () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getnamedrefs", () -> this.delegate.getNamedRefs(params, pagingToken));
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getcommits", () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getkeys", () -> this.delegate.getKeys(ref, pagingToken, withContent));
    }

    @Override
    public Content getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return this.delegate1Ex("getvalue", () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<Key, Content> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        return this.delegate1Ex("getvalues", () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getdiffs", () -> this.delegate.getDiffs(from, to, pagingToken));
    }

    @Override
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.delegateStream1Ex("getreflog", () -> this.delegate.getRefLog(refLogId));
    }

    private void measure(String requestName, Timer.Sample sample, Exception failure) {
        Timer timer = Timer.builder((String)"nessie.versionstore.request").tags(this.commonTags).tag("request", requestName).tag("error", Boolean.toString(failure != null)).publishPercentileHistogram().register(this.registry);
        sample.stop(timer);
    }

    private <R, E extends VersionStoreException> PaginationIterator<R> delegatePaginationIterator(final String requestName, DelegateWith1<PaginationIterator<R>, E> delegate) throws E {
        final Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            final PaginationIterator<R> r = delegate.handle();
            return new PaginationIterator<R>(){

                @Override
                public String tokenForCurrent() {
                    return r.tokenForCurrent();
                }

                @Override
                public String tokenForEntry(R entry) {
                    return r.tokenForEntry(entry);
                }

                @Override
                public void close() {
                    try {
                        r.close();
                    }
                    finally {
                        MetricsVersionStore.this.measure(requestName, sample, null);
                    }
                }

                @Override
                public boolean hasNext() {
                    return r.hasNext();
                }

                @Override
                public R next() {
                    return r.next();
                }
            };
        }
        catch (IllegalArgumentException | VersionStoreException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R, E extends VersionStoreException> Stream<R> delegateStream1Ex(String requestName, DelegateWith1<Stream<R>, E> delegate) throws E {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            return (Stream)delegate.handle().onClose(() -> this.measure(requestName, sample, null));
        }
        catch (IllegalArgumentException | VersionStoreException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R, E1 extends VersionStoreException> R delegate1Ex(String requestName, DelegateWith1<R, E1> delegate) throws E1 {
        return (R)this.delegate2ExR(requestName, delegate::handle);
    }

    private <E1 extends VersionStoreException, E2 extends VersionStoreException> void delegate2Ex(String requestName, DelegateWith2<E1, E2> delegate) throws E1, E2 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            delegate.handle();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    private <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R delegate2ExR(String requestName, DelegateWith2R<R, E1, E2> delegate) throws E1, E2 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            R r = delegate.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    @FunctionalInterface
    static interface DelegateWith2R<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface DelegateWith2<E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public void handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface DelegateWith1<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }
}

