/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.testworker;

import com.google.protobuf.ByteString;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.testworker.TestContentSerializer;
import org.projectnessie.versioned.testworker.WithAttachmentsContent;

public class WithAttachmentsSerializer
extends TestContentSerializer<WithAttachmentsContent> {
    public Content.Type contentType() {
        return WithAttachmentsContent.WITH_ATTACHMENTS;
    }

    public byte payload() {
        return 126;
    }

    public ByteString toStoreOnReferenceState(WithAttachmentsContent content, Consumer<ContentAttachment> attachmentConsumer) {
        String value = content.getOnRef();
        content.getPerContent().forEach(attachmentConsumer);
        return ByteString.copyFromUtf8((String)(content.getType().name() + ":" + content.getId() + ":" + value));
    }

    public WithAttachmentsContent applyId(WithAttachmentsContent content, String id) {
        return WithAttachmentsContent.withAttachments(content.getPerContent(), content.getOnRef(), id);
    }

    @Override
    protected WithAttachmentsContent valueFromStore(String contentId, String onRef, ByteString global, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever) {
        Assertions.assertThat((Iterable)global).isNull();
        Stream keys = Stream.empty();
        try (Stream<ContentAttachment> attachments = attachmentsRetriever.apply(keys);){
            Assertions.assertThat(attachments).isNotEmpty();
            WithAttachmentsContent withAttachmentsContent = WithAttachmentsContent.withAttachments(attachments.collect(Collectors.toList()), onRef, contentId);
            return withAttachmentsContent;
        }
    }
}

