/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

public abstract class AbstractAssign
extends AbstractNestedVersionStore {
    protected AbstractAssign(VersionStore store) {
        super(store);
    }

    @Test
    public void assign() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        Hash commit = this.commit("Some commit").toBranch(branch);
        this.store().create((NamedRef)BranchName.of((String)"bar"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag1"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag2"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag3"), Optional.of(commit));
        Hash anotherCommit = this.commit("Another commit").toBranch(branch);
        this.store().assign((NamedRef)TagName.of((String)"tag2"), Optional.of(commit), anotherCommit);
        this.store().assign((NamedRef)TagName.of((String)"tag3"), Optional.empty(), anotherCommit);
        org.junit.jupiter.api.Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.store().assign((NamedRef)BranchName.of((String)"baz"), Optional.empty(), anotherCommit));
        org.junit.jupiter.api.Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.store().assign((NamedRef)TagName.of((String)"unknowon-tag"), Optional.empty(), anotherCommit));
        org.junit.jupiter.api.Assertions.assertThrows(ReferenceConflictException.class, () -> this.store().assign((NamedRef)TagName.of((String)"tag1"), Optional.of(initialHash), commit));
        org.junit.jupiter.api.Assertions.assertThrows(ReferenceConflictException.class, () -> this.store().assign((NamedRef)TagName.of((String)"tag1"), Optional.of(initialHash), anotherCommit));
        org.junit.jupiter.api.Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.store().assign((NamedRef)TagName.of((String)"tag1"), Optional.of(commit), Hash.of((String)"1234567890abcdef")));
        Assertions.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractAssign.commit(anotherCommit, "Another commit", commit), AbstractAssign.commit(commit, "Some commit", initialHash)});
        Assertions.assertThat(this.commitsList((Ref)BranchName.of((String)"bar"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(commit, "Some commit", initialHash)});
        Assertions.assertThat(this.commitsList((Ref)TagName.of((String)"tag1"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(commit, "Some commit", initialHash)});
        Assertions.assertThat(this.commitsList((Ref)TagName.of((String)"tag2"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(anotherCommit, "Another commit", commit), AbstractAssign.commit(commit, "Some commit", initialHash)});
    }

    @Test
    public void assignReferenceToFreshMain() throws ReferenceNotFoundException, ReferenceAlreadyExistsException, ReferenceConflictException {
        ReferenceInfo main = this.store.getNamedRef("main", GetNamedRefsParams.DEFAULT);
        try (Stream commits = this.store().getCommits((Ref)main.getHash(), false);){
            Assertions.assertThat((Stream)commits).isEmpty();
        }
        try (Stream refs = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT);){
            Assertions.assertThat((Stream)refs).extracting(r -> r.getNamedRef().getName()).containsExactly((Object[])new String[]{main.getNamedRef().getName()});
        }
        BranchName testBranch = BranchName.of((String)"testBranch");
        Hash testBranchHash = this.store.create((NamedRef)testBranch, Optional.empty());
        this.store.assign((NamedRef)testBranch, Optional.of(testBranchHash), main.getHash());
        Assertions.assertThat((Object)this.store.getNamedRef(testBranch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)main.getHash());
        TagName testTag = TagName.of((String)"testTag");
        Hash testTagHash = this.store.create((NamedRef)testTag, Optional.empty());
        this.store.assign((NamedRef)testTag, Optional.of(testTagHash), main.getHash());
        Assertions.assertThat((Object)this.store.getNamedRef(testTag.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)main.getHash());
    }
}

