/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractDiff
extends AbstractNestedVersionStore {
    public static final OnRefOnly V_1 = OnRefOnly.newOnRef("v1");
    public static final OnRefOnly V_2 = OnRefOnly.newOnRef("v2");
    public static final OnRefOnly V_2_A = OnRefOnly.newOnRef("v2a");
    public static final OnRefOnly V_3 = OnRefOnly.newOnRef("v3");

    protected AbstractDiff(VersionStore store) {
        super(store);
    }

    @Test
    protected void checkDiff() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"checkDiff");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initial = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        Hash firstCommit = this.commit("First Commit").put("k1", (Content)V_1).put("k2", (Content)V_2).toBranch(branch);
        Hash secondCommit = this.commit("Second Commit").put("k2", (Content)V_2_A).put("k3", (Content)V_3).toBranch(branch);
        List<Diff> startToSecond = this.diffAsList(initial, secondCommit);
        Assertions.assertThat(startToSecond).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((Key)Key.of((String[])new String[]{"k1"}), Optional.empty(), Optional.of(V_1)), Diff.of((Key)Key.of((String[])new String[]{"k2"}), Optional.empty(), Optional.of(V_2_A)), Diff.of((Key)Key.of((String[])new String[]{"k3"}), Optional.empty(), Optional.of(V_3))});
        List<Diff> secondToStart = this.diffAsList(secondCommit, initial);
        Assertions.assertThat(secondToStart).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((Key)Key.of((String[])new String[]{"k1"}), Optional.of(V_1), Optional.empty()), Diff.of((Key)Key.of((String[])new String[]{"k2"}), Optional.of(V_2_A), Optional.empty()), Diff.of((Key)Key.of((String[])new String[]{"k3"}), Optional.of(V_3), Optional.empty())});
        List<Diff> firstToSecond = this.diffAsList(firstCommit, secondCommit);
        Assertions.assertThat(firstToSecond).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((Key)Key.of((String[])new String[]{"k2"}), Optional.of(V_2), Optional.of(V_2_A)), Diff.of((Key)Key.of((String[])new String[]{"k3"}), Optional.empty(), Optional.of(V_3))});
        List<Diff> firstToFirst = this.diffAsList(firstCommit, firstCommit);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstToFirst.isEmpty());
    }

    private List<Diff> diffAsList(Hash initial, Hash secondCommit) throws ReferenceNotFoundException {
        try (Stream diffStream = this.store().getDiffs((Ref)initial, (Ref)secondCommit);){
            List<Diff> list = diffStream.collect(Collectors.toList());
            return list;
        }
    }
}

