/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractCommitLog
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractCommitLog(VersionStore store) {
        super(store);
    }

    @Test
    public void commitLogPaging() throws Exception {
        List logPage;
        BranchName branch = BranchName.of((String)"commitLogPaging");
        Hash createHash = this.store().create((NamedRef)branch, Optional.empty());
        int commits = 95;
        Hash[] commitHashes = new Hash[commits];
        ArrayList<CommitMeta> messages = new ArrayList<CommitMeta>(commits);
        for (int i = 0; i < commits; ++i) {
            CommitMeta msg = CommitMeta.fromMessage((String)String.format("commit#%05d", i));
            messages.add(msg);
            commitHashes[i] = this.store().commit(branch, Optional.of(i == 0 ? createHash : commitHashes[i - 1]), msg, (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"table"}), (Content)OnRefOnly.newOnRef(String.format("value#%05d", i)))));
        }
        Collections.reverse(messages);
        List justTwo = this.commitsList((Ref)branch, s -> s.limit(2L).map(Commit::getCommitMeta), false);
        this.soft.assertThat(justTwo).isEqualTo(messages.subList(0, 2));
        List justTen = this.commitsList((Ref)branch, s -> s.limit(10L).map(Commit::getCommitMeta), false);
        this.soft.assertThat(justTen).isEqualTo(messages.subList(0, 10));
        int pageSize = 10;
        this.soft.assertThat(commits % (pageSize - 1)).isNotEqualTo(0);
        Hash lastHash = null;
        int offset = 0;
        do {
            logPage = this.commitsList((Ref)(lastHash == null ? branch : lastHash), s -> s.limit(pageSize), false);
            this.soft.assertThat(logPage.stream().map(Commit::getCommitMeta).collect(Collectors.toList())).isEqualTo(messages.subList(offset, Math.min(offset + pageSize, commits)));
            lastHash = ((Commit)logPage.get(logPage.size() - 1)).getHash();
        } while ((offset += pageSize - 1) < commits);
        logPage = this.commitsList((Ref)lastHash, s -> s.limit(pageSize), false);
        this.soft.assertThat(logPage.stream().map(Commit::getCommitMeta).collect(Collectors.toList())).isEqualTo(Collections.singletonList((CommitMeta)messages.get(commits - 1)));
    }

    @Test
    public void commitLogExtendedNoGlobalState() throws Exception {
        BranchName branch = BranchName.of((String)"commitLogExtended");
        Hash firstParent = this.store().create((NamedRef)branch, Optional.empty());
        int numCommits = 10;
        List hashes = IntStream.rangeClosed(1, numCommits).mapToObj(i -> {
            try {
                return this.commit("Commit #" + i).put("k" + i, (Content)OnRefOnly.onRef("v" + i, "c" + i)).put("key" + i, (Content)OnRefOnly.onRef("value" + i, "cid" + i)).delete("delete" + i).toBranch(branch);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List parentHashes = Stream.concat(Stream.of(firstParent), hashes.subList(0, 9).stream()).collect(Collectors.toList());
        ((ListAssert)this.soft.assertThat(Lists.reverse(this.commitsList((Ref)branch, false))).allSatisfy(c -> {
            Assertions.assertThat((List)c.getOperations()).isNull();
            Assertions.assertThat((Object)c.getParentHash()).isNotNull();
            Assertions.assertThat((List)c.getAdditionalParents()).isNotNull();
        })).extracting(Commit::getHash).containsExactlyElementsOf(hashes);
        List commits = Lists.reverse(this.commitsList((Ref)branch, true));
        this.soft.assertThat(IntStream.rangeClosed(1, numCommits)).allSatisfy(i -> {
            Commit c = (Commit)commits.get(i - 1);
            Assertions.assertThat((Object)c).extracting(new Function[]{Commit::getCommitMeta, Commit::getHash, Commit::getParentHash, Commit::getOperations}).containsExactly(new Object[]{CommitMeta.fromMessage((String)("Commit #" + i)), hashes.get(i - 1), parentHashes.get(i - 1), Arrays.asList(Delete.of((Key)Key.of((String[])new String[]{"delete" + i})), Put.of((Key)Key.of((String[])new String[]{"k" + i}), (Content)OnRefOnly.onRef("v" + i, "c" + i)), Put.of((Key)Key.of((String[])new String[]{"key" + i}), (Content)OnRefOnly.onRef("value" + i, "cid" + i)))});
        });
    }
}

