/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractCommits
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_3 = OnRefOnly.newOnRef("v1_3");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_3_2 = OnRefOnly.newOnRef("v3_2");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly NEW_v2_1 = OnRefOnly.newOnRef("new_v2_1");

    protected AbstractCommits(VersionStore store) {
        super(store);
    }

    @Test
    public void commitToBranch() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash createHash = this.store().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThat((Object)createHash).isEqualTo((Object)initialHash);
        Hash commitHash0 = this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Some commit"), Collections.emptyList());
        Hash commitHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThat((Object)commitHash).isEqualTo((Object)commitHash0);
        this.soft.assertThat((Object)commitHash).isNotEqualTo((Object)initialHash);
        this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Another commit"), Collections.emptyList());
        Hash anotherCommitHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(anotherCommitHash, "Another commit", commitHash), AbstractCommits.commit(commitHash, "Some commit", initialHash)});
        this.soft.assertThat(this.commitsList((Ref)commitHash, false)).contains((Object[])new Commit[]{AbstractCommits.commit(commitHash, "Some commit", initialHash)});
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)branch, Optional.of(initialHash))).isInstanceOf(ReferenceConflictException.class);
        this.store().delete((NamedRef)branch, Optional.of(anotherCommitHash));
        this.soft.assertThatThrownBy(() -> this.store().hashOnReference((NamedRef)branch, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        try (Stream<ReferenceInfo> str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT).filter(this::filterMainBranch);){
            this.soft.assertThat(str).isEmpty();
        }
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)branch, Optional.of(commitHash))).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitSomeOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash base = this.store().create((NamedRef)branch, Optional.empty());
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(branch);
        Hash secondCommit = this.commit("Second Commit").put("t1", (Content)V_1_2).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(branch);
        Hash thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(branch);
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(thirdCommit, "Third Commit", secondCommit), AbstractCommits.commit(secondCommit, "Second Commit", initialCommit), AbstractCommits.commit(initialCommit, "Initial Commit", base)});
        try (Stream<Key> keys = this.store().getKeys((Ref)branch).map(KeyEntry::getKey);){
            this.soft.assertThat(keys).containsExactlyInAnyOrder((Object[])new Key[]{Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t4"})});
        }
        keys = this.store().getKeys((Ref)secondCommit).map(KeyEntry::getKey);
        try {
            this.soft.assertThat(keys).containsExactlyInAnyOrder((Object[])new Key[]{Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t4"})});
        }
        finally {
            if (keys != null) {
                keys.close();
            }
        }
        keys = this.store().getKeys((Ref)initialCommit).map(KeyEntry::getKey);
        try {
            this.soft.assertThat(keys).containsExactlyInAnyOrder((Object[])new Key[]{Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})});
        }
        finally {
            if (keys != null) {
                keys.close();
            }
        }
        this.soft.assertThat(this.store().getValues((Ref)secondCommit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"}), Key.of((String[])new String[]{"t4"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1)));
        this.soft.assertThat(this.store().getValues((Ref)initialCommit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"}), Key.of((String[])new String[]{"t4"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_1), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"t1"}))).isEqualTo((Object)V_1_2);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"t2"}))).isEqualTo((Object)V_2_2);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"t3"}))).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"t4"}))).isEqualTo((Object)V_4_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, Key.of((String[])new String[]{"t1"}))).isEqualTo((Object)V_1_2);
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, Key.of((String[])new String[]{"t2"}))).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, Key.of((String[])new String[]{"t3"}))).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, Key.of((String[])new String[]{"t4"}))).isEqualTo((Object)V_4_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)initialCommit, Key.of((String[])new String[]{"t1"}))).isEqualTo((Object)V_1_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)initialCommit, Key.of((String[])new String[]{"t2"}))).isEqualTo((Object)V_2_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)initialCommit, Key.of((String[])new String[]{"t3"}))).isEqualTo((Object)V_3_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)initialCommit, Key.of((String[])new String[]{"t4"}))).isNull();
    }

    @Test
    public void commitNonConflictingOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash base = this.store().create((NamedRef)branch, Optional.empty());
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(branch);
        Hash t1Commit = this.commit("T1 Commit").fromReference(initialCommit).put("t1", (Content)V_1_2).toBranch(branch);
        Hash t2Commit = this.commit("T2 Commit").fromReference(initialCommit).delete("t2").toBranch(branch);
        Hash t3Commit = this.commit("T3 Commit").fromReference(initialCommit).unchanged("t3").toBranch(branch);
        Hash extraCommit = this.commit("Extra Commit").fromReference(t1Commit).put("t1", (Content)V_1_3).put("t3", (Content)V_3_2).toBranch(branch);
        Hash newT2Commit = this.commit("New T2 Commit").fromReference(t2Commit).put("t2", (Content)NEW_v2_1).toBranch(branch);
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(newT2Commit, "New T2 Commit", extraCommit), AbstractCommits.commit(extraCommit, "Extra Commit", t3Commit), AbstractCommits.commit(t3Commit, "T3 Commit", t2Commit), AbstractCommits.commit(t2Commit, "T2 Commit", t1Commit), AbstractCommits.commit(t1Commit, "T1 Commit", initialCommit), AbstractCommits.commit(initialCommit, "Initial Commit", base)});
        try (Stream<Key> keys = this.store().getKeys((Ref)branch).map(KeyEntry::getKey);){
            this.soft.assertThat(keys).containsExactlyInAnyOrder((Object[])new Key[]{Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})});
        }
        this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)NEW_v2_1), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(this.store().getValues((Ref)newT2Commit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)NEW_v2_1), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(this.store().getValues((Ref)extraCommit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(this.store().getValues((Ref)t3Commit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat(this.store().getValues((Ref)t2Commit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat(this.store().getValues((Ref)t1Commit, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
    }

    @Test
    public void commitConflictingOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).toBranch(branch);
        Hash secondCommit = this.commit("Second Commit").put("t1", (Content)V_1_2).delete("t2").put("t3", (Content)V_3_1).toBranch(branch);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t1", (Content)V_1_3).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t2", (Content)V_2_2).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t3", (Content)V_3_2).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t1").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t2").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t3").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty())).isEqualTo((Object)secondCommit);
    }

    @Test
    public void forceCommitConflictingOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).toBranch(branch);
        this.commit("Second Commit").put("t1", (Content)V_1_2).delete("t2").put("t3", (Content)V_3_1).toBranch(branch);
        Hash putCommit = this.forceCommit("Conflicting Commit").put("t1", (Content)V_1_3).put("t2", (Content)V_2_2).put("t3", (Content)V_3_2).toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty())).isEqualTo((Object)putCommit);
        this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        Hash unchangedCommit = this.commit("Conflicting Commit").unchanged("t1").unchanged("t2").unchanged("t3").toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty())).isEqualTo((Object)unchangedCommit);
        this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)Key.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        Hash deleteCommit = this.commit("Conflicting Commit").delete("t1").delete("t2").delete("t3").toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty())).isEqualTo((Object)deleteCommit);
        this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"t1"}), Key.of((String[])new String[]{"t2"}), Key.of((String[])new String[]{"t3"})))).isEmpty();
    }

    @Test
    public void commitDuplicateValues() throws Exception {
        BranchName branch = BranchName.of((String)"dupe-values");
        this.store().create((NamedRef)branch, Optional.empty());
        OnRefOnly foo1 = OnRefOnly.newOnRef("foo");
        OnRefOnly foo2 = OnRefOnly.newOnRef("foo");
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"metadata"), (List)ImmutableList.of((Object)this.put("keyA", foo1), (Object)this.put("keyB", foo2)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"keyA"}))).isEqualTo((Object)foo1);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, Key.of((String[])new String[]{"keyB"}))).isEqualTo((Object)foo2);
    }

    @Test
    public void commitWithInvalidBranch() {
        BranchName branch = BranchName.of((String)"unknown");
        this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"New commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitWithUnknownReference() throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.of(Hash.of((String)"1234567890abcdef")), CommitMeta.fromMessage((String)"New commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitWithInvalidReference() throws ReferenceNotFoundException, ReferenceConflictException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Some commit"), Collections.emptyList());
        Hash commitHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        BranchName branch2 = BranchName.of((String)"bar");
        this.store().create((NamedRef)branch2, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().commit(branch2, Optional.of(commitHash), CommitMeta.fromMessage((String)"Another commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    void commitWithValidation() throws Exception {
        BranchName branch = BranchName.of((String)"main");
        Key key = Key.of((String[])new String[]{"my", "table0"});
        Hash branchHead = this.store().getNamedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        String cid = "cid-0";
        ArithmeticException exception = new ArithmeticException("Whatever");
        this.soft.assertThatThrownBy(() -> this.doCommitWithValidation(branch, cid, key, () -> {
            try {
                Assertions.assertThat((Object)this.store().getValue((Ref)branch, key)).isNull();
                Stream ignore = this.store().getKeys((Ref)branch);
                if (ignore != null) {
                    ignore.close();
                }
            }
            catch (ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
            throw exception;
        })).isSameAs((Object)exception);
        this.soft.assertThat((Object)this.store().getNamedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)branchHead);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key)).isNull();
    }

    void doCommitWithValidation(BranchName branch, String cid, Key key, Callable<Void> validator) throws Exception {
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial commit meta"), Collections.singletonList(Put.of((Key)key, (Content)OnRefOnly.newOnRef("some value"))), validator);
    }

    @Test
    void duplicateKeys() {
        BranchName branch = BranchName.of((String)"main");
        Key key = Key.of((String[])new String[]{"my.awesome.table"});
        String oldContentsId = "cid";
        String tableRefState = "table ref state";
        OnRefOnly createValue1 = OnRefOnly.onRef("no no - not this", oldContentsId);
        OnRefOnly createValue2 = OnRefOnly.onRef(tableRefState, oldContentsId);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(Put.of((Key)key, (Content)createValue1), Put.of((Key)key, (Content)createValue2)))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(Unchanged.of((Key)key), Put.of((Key)key, (Content)createValue2)))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(Delete.of((Key)key), Put.of((Key)key, (Content)createValue2)))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(Delete.of((Key)key), Unchanged.of((Key)key)))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
    }
}

