/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractContents
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractContents(VersionStore store) {
        super(store);
    }

    @Test
    public void getValueForEmptyBranch() throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"empty-branch");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash hash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThat((Object)this.store().getValue((Ref)hash, Key.of((String[])new String[]{"arbitrary"}))).isNull();
    }

    @Test
    void recreateTable() throws Exception {
        BranchName branch = BranchName.of((String)"recreateTable-main");
        Key key = Key.of((String[])new String[]{"recreateTable"});
        this.store().create((NamedRef)branch, Optional.empty());
        OnRefOnly initialState = OnRefOnly.newOnRef("value");
        Hash ancestor = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"create table"), Collections.singletonList(Put.of((Key)key, (Content)initialState)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key)).isEqualTo((Object)initialState);
        this.soft.assertThat((Object)this.store().getValue((Ref)ancestor, key)).isEqualTo((Object)initialState);
        Hash delete = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"drop table"), (List)ImmutableList.of((Object)Delete.of((Key)key)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key)).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)delete, key)).isNull();
        OnRefOnly recreateState = OnRefOnly.newOnRef("value");
        Hash recreate = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"drop table"), (List)ImmutableList.of((Object)Put.of((Key)key, (Content)recreateState)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key)).isEqualTo((Object)recreateState);
        this.soft.assertThat((Object)this.store().getValue((Ref)recreate, key)).isEqualTo((Object)recreateState);
    }
}

