/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.SoftAssertions;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.CommitBuilder;

public abstract class AbstractNestedVersionStore {
    protected final VersionStore store;

    protected AbstractNestedVersionStore(VersionStore store) {
        this.store = store;
    }

    protected VersionStore store() {
        return this.store;
    }

    protected List<Commit> commitsList(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.commitsList(ref, Function.identity(), fetchAdditionalInfo);
    }

    protected <T> List<T> commitsList(Ref ref, Function<Stream<Commit>, Stream<T>> streamFunction, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        try (Stream s = this.store().getCommits(ref, fetchAdditionalInfo);){
            List list = streamFunction.apply(s).collect(Collectors.toList());
            return list;
        }
    }

    protected static Commit commit(Hash hash, String commitMeta) {
        return AbstractNestedVersionStore.commit(hash, commitMeta, null);
    }

    protected static Commit commit(Hash hash, String commitMeta, Hash parentHash) {
        return AbstractNestedVersionStore.commit(hash, CommitMeta.fromMessage((String)commitMeta), parentHash);
    }

    protected static Commit commit(Hash hash, CommitMeta commitMessage) {
        return AbstractNestedVersionStore.commit(hash, commitMessage, null);
    }

    protected static Commit commit(Hash hash, CommitMeta commitMessage, Hash parentHash) {
        ImmutableCommit.Builder builder = Commit.builder().hash(hash).commitMeta(commitMessage);
        if (parentHash != null) {
            builder.parentHash(parentHash);
        }
        return builder.build();
    }

    protected CommitBuilder forceCommit(String message) {
        return new CommitBuilder(this.store()).withMetadata(CommitMeta.fromMessage((String)message));
    }

    protected CommitBuilder commit(String message) {
        return new CommitBuilder(this.store()).withMetadata(CommitMeta.fromMessage((String)message)).fromLatest();
    }

    protected Put put(String key, Content value) {
        return Put.of((Key)Key.of((String[])new String[]{key}), (Content)value);
    }

    protected Delete delete(String key) {
        return Delete.of((Key)Key.of((String[])new String[]{key}));
    }

    protected Unchanged unchanged(String key) {
        return Unchanged.of((Key)Key.of((String[])new String[]{key}));
    }

    protected boolean filterMainBranch(ReferenceInfo<CommitMeta> r) {
        return !r.getNamedRef().getName().equals("main");
    }

    protected static void assertCommitMeta(SoftAssertions soft, List<Commit> current, List<Commit> expected, MetadataRewriter<CommitMeta> commitMetaModifier) {
        soft.assertThat(current).map(Commit::getCommitMeta).containsExactlyElementsOf((Iterable)expected.stream().map(Commit::getCommitMeta).map(arg_0 -> commitMetaModifier.rewriteSingle(arg_0)).collect(Collectors.toList()));
    }
}

