/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.testworker;

import com.google.protobuf.ByteString;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ContentTypes;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.store.ContentSerializer;
import org.projectnessie.versioned.testworker.OnRefOnly;

abstract class TestContentSerializer<C extends Content>
implements ContentSerializer<C> {
    TestContentSerializer() {
    }

    public Content.Type getType(ByteString onRefContent) {
        String serialized = onRefContent.toStringUtf8();
        int i = serialized.indexOf(58);
        if (i == -1) {
            return OnRefOnly.ON_REF_ONLY;
        }
        String typeString = serialized.substring(0, i);
        return ContentTypes.forName((String)typeString);
    }

    public C valueFromStore(byte payload, ByteString onReferenceValue, Supplier<ByteString> globalState, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever) {
        String serialized = onReferenceValue.toStringUtf8();
        int i = serialized.indexOf(58);
        String typeString = serialized.substring(0, i);
        serialized = serialized.substring(i + 1);
        Assertions.assertThat((String)typeString).isEqualTo(this.contentType().name());
        i = serialized.indexOf(58);
        String contentId = serialized.substring(0, i);
        i = serialized.indexOf(58);
        String onRef = serialized.substring(i + 1);
        ByteString global = globalState.get();
        return this.valueFromStore(contentId, onRef, global, attachmentsRetriever);
    }

    protected abstract C valueFromStore(String var1, String var2, ByteString var3, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> var4);
}

