/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractSingleBranch
extends AbstractNestedVersionStore {
    protected AbstractSingleBranch(VersionStore store) {
        super(store);
    }

    static List<SingleBranchParam> singleBranchManyUsersCases() {
        return Arrays.asList(new SingleBranchParam("singleBranchManyUsersSingleTable", user -> "single-table", true), new SingleBranchParam("singleBranchManyUsersDistinctTables", user -> String.format("user-table-%d", user), false));
    }

    @ParameterizedTest
    @MethodSource(value={"singleBranchManyUsersCases"})
    void singleBranchManyUsers(SingleBranchParam param) throws Exception {
        BranchName branch = BranchName.of((String)param.branchName);
        int numUsers = 3;
        int numCommits = 20;
        Object[] hashesKnownByUser = new Hash[numUsers];
        Hash createHash = this.store().create((NamedRef)branch, Optional.empty());
        Arrays.fill(hashesKnownByUser, createHash);
        ArrayList<CommitMeta> expectedValues = new ArrayList<CommitMeta>();
        for (int commitNum = 0; commitNum < numCommits; ++commitNum) {
            for (int user = 0; user < numUsers; ++user) {
                Hash commitHash;
                Object hashKnownByUser = hashesKnownByUser[user];
                CommitMeta msg = CommitMeta.fromMessage((String)String.format("user %03d/commit %03d", user, commitNum));
                expectedValues.add(msg);
                Key key = Key.of((String[])new String[]{param.tableNameGen.apply(user)});
                List<Operation> ops = this.singleBranchManyUsersOps(branch, commitNum, user, (Hash)hashKnownByUser, key);
                try {
                    commitHash = this.store().commit(branch, Optional.of(hashKnownByUser), msg, ops);
                }
                catch (ReferenceConflictException inconsistentValueException) {
                    if (param.allowInconsistentValueException) {
                        hashKnownByUser = this.store().hashOnReference((NamedRef)branch, Optional.empty());
                        ops = this.singleBranchManyUsersOps(branch, commitNum, user, (Hash)hashKnownByUser, key);
                        commitHash = this.store().commit(branch, Optional.of(hashKnownByUser), msg, ops);
                    }
                    throw inconsistentValueException;
                }
                Assertions.assertNotEquals((Object)hashKnownByUser, (Object)commitHash);
                hashesKnownByUser[user] = commitHash;
            }
        }
        List committedValues = this.commitsList((Ref)branch, s -> s.map(Commit::getCommitMeta), false);
        Collections.reverse(expectedValues);
        Assertions.assertEquals(expectedValues, committedValues);
    }

    private List<Operation> singleBranchManyUsersOps(BranchName branch, int commitNum, int user, Hash hashKnownByUser, Key key) throws ReferenceNotFoundException {
        ImmutableList ops;
        Content existing = this.store().getValue((Ref)this.store.hashOnReference((NamedRef)branch, Optional.of(hashKnownByUser)), key);
        if (existing != null) {
            OnRefOnly value = OnRefOnly.onRef(String.format("data_file_%03d_%03d", user, commitNum), existing.getId());
            ops = ImmutableList.of((Object)Put.of((Key)key, (Content)value, (Content)existing));
        } else {
            OnRefOnly value = OnRefOnly.newOnRef(String.format("data_file_%03d_%03d", user, commitNum));
            ops = ImmutableList.of((Object)Put.of((Key)key, (Content)value));
        }
        return ops;
    }

    static class SingleBranchParam {
        final String branchName;
        final IntFunction<String> tableNameGen;
        final boolean allowInconsistentValueException;

        SingleBranchParam(String branchName, IntFunction<String> tableNameGen, boolean allowInconsistentValueException) {
            this.branchName = branchName;
            this.tableNameGen = tableNameGen;
            this.allowInconsistentValueException = allowInconsistentValueException;
        }

        public String toString() {
            return "branchName='" + this.branchName + '\'' + ", tableNameGen=" + this.tableNameGen + ", allowInconsistentValueException=" + this.allowInconsistentValueException;
        }
    }
}

