/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractTransplant
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final String T_1 = "t1";
    private static final String T_2 = "t2";
    private static final String T_3 = "t3";
    private static final String T_4 = "t4";
    private static final String T_5 = "t5";
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly V_5_1 = OnRefOnly.newOnRef("v5_1");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash secondCommit;
    private Hash thirdCommit;
    private List<Commit> commits;

    protected AbstractTransplant(VersionStore store) {
        super(store);
    }

    private MetadataRewriter<CommitMeta> createMetadataRewriter(final String suffix) {
        return new MetadataRewriter<CommitMeta>(){

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                return metadata;
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                return CommitMeta.fromMessage((String)metadata.stream().map(cm -> cm.getMessage() + suffix).collect(Collectors.joining("\n-----------------------------------\n")));
            }
        };
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.firstCommit = this.commit("Initial Commit").put(T_1, (Content)V_1_1).put(T_2, (Content)V_2_1).put(T_3, (Content)V_3_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, Key.of((String[])new String[]{T_1}));
        this.secondCommit = this.commit("Second Commit").put(T_1, (Content)V_1_2.withId(t1), t1).delete(T_2).delete(T_3).put(T_4, (Content)V_4_1).toBranch(branch);
        this.thirdCommit = this.commit("Third Commit").put(T_2, (Content)V_2_2).unchanged(T_4).toBranch(branch);
        this.commits = this.commitsList((Ref)branch, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantOnEmptyBranch(boolean individualCommits) throws VersionStoreException {
        this.checkTransplantOnEmptyBranch(this.createMetadataRewriter(""), individualCommits);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantOnEmptyBranchModify(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = this.checkTransplantOnEmptyBranch(this.createMetadataRewriter(""), individualCommits);
        if (!individualCommits) {
            ((ObjectAssert)Assertions.assertThat(this.commitsList((Ref)newBranch, false)).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
        }
    }

    private BranchName checkTransplantOnEmptyBranch(MetadataRewriter<CommitMeta> commitMetaModify, boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_1");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), commitMetaModify, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(Key.of((String[])new String[]{T_1}), Key.of((String[])new String[]{T_2}), Key.of((String[])new String[]{T_3}), Key.of((String[])new String[]{T_4}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{T_4}), (Object)((Object)V_4_1)));
        if (individualCommits) {
            AbstractTransplant.assertCommitMeta(this.soft, this.commitsList((Ref)newBranch, false).subList(0, 3), this.commits, commitMetaModify);
        }
        return newBranch;
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithPreviousCommit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Unrelated commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        Assertions.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(Key.of((String[])new String[]{T_1}), Key.of((String[])new String[]{T_2}), Key.of((String[])new String[]{T_3}), Key.of((String[])new String[]{T_4}), Key.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)Key.of((String[])new String[]{T_5}), (Object)((Object)V_5_1)));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWitConflictingCommit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_1, (Content)V_1_4).toBranch(newBranch);
        this.soft.assertThatThrownBy(() -> this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithDelete(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_4");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_1, (Content)V_1_4).toBranch(newBranch);
        this.commit("Another commit").delete(T_1).toBranch(newBranch);
        this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(Key.of((String[])new String[]{T_1}), Key.of((String[])new String[]{T_2}), Key.of((String[])new String[]{T_3}), Key.of((String[])new String[]{T_4}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{T_4}), (Object)((Object)V_4_1)));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantOnNonExistingBranch(boolean individualCommits) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        this.soft.assertThatThrownBy(() -> this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithNonExistingCommit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().transplant(newBranch, Optional.of(this.initialHash), Collections.singletonList(Hash.of((String)"1234567890abcdef")), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithNoExpectedHash(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_7");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        Content t5 = this.store().getValue((Ref)newBranch, Key.of((String[])new String[]{T_5}));
        this.commit("Another commit").put(T_5, (Content)V_1_4.withId(t5), t5).toBranch(newBranch);
        this.store().transplant(newBranch, Optional.empty(), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(Key.of((String[])new String[]{T_1}), Key.of((String[])new String[]{T_2}), Key.of((String[])new String[]{T_3}), Key.of((String[])new String[]{T_4}), Key.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)Key.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)Key.of((String[])new String[]{T_5}), (Object)((Object)V_1_4)));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithCommitsInWrongOrder(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_8");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().transplant(newBranch, Optional.empty(), Arrays.asList(this.secondCommit, this.firstCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkInvalidBranchHash(boolean individualCommits) throws VersionStoreException {
        BranchName anotherBranch = BranchName.of((String)"bar");
        this.store().create((NamedRef)anotherBranch, Optional.empty());
        Hash unrelatedCommit = this.commit("Another Commit").put(T_1, (Content)V_1_1).put(T_2, (Content)V_2_1).put(T_3, (Content)V_3_1).toBranch(anotherBranch);
        BranchName newBranch = BranchName.of((String)"bar_1");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().transplant(newBranch, Optional.of(unrelatedCommit), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void transplantBasic(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Unrelated commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        this.store().transplant(newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(Key.of((String[])new String[]{T_1}), Key.of((String[])new String[]{T_4}), Key.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)Key.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)Key.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)Key.of((String[])new String[]{T_5}), (Object)((Object)V_5_1)));
    }
}

