/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.SoftAssertions;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.tests.CommitBuilder;

public abstract class AbstractNestedVersionStore {
    protected final VersionStore store;

    protected AbstractNestedVersionStore(VersionStore store) {
        this.store = store;
    }

    protected VersionStore store() {
        return this.store;
    }

    protected List<Commit> commitsList(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        try (PaginationIterator s = this.store().getCommits(ref, fetchAdditionalInfo);){
            ArrayList arrayList = Lists.newArrayList((Iterator)s);
            return arrayList;
        }
    }

    protected <T> List<T> commitsListMap(Ref ref, int limit, Function<Commit, T> mapper) throws ReferenceNotFoundException {
        try (PaginationIterator s = this.store().getCommits(ref, false);){
            ArrayList<T> r = new ArrayList<T>();
            while (r.size() < limit && s.hasNext()) {
                r.add(mapper.apply((Commit)s.next()));
            }
            ArrayList<T> arrayList = r;
            return arrayList;
        }
    }

    protected static Commit commit(Hash hash, String commitMeta, Hash parentHash) {
        return AbstractNestedVersionStore.commit(hash, (CommitMeta)CommitMeta.builder().message(commitMeta).hash(hash.asString()).addParentCommitHashes(parentHash.asString()).build(), parentHash);
    }

    protected static Commit commit(Hash hash, CommitMeta commitMessage) {
        return AbstractNestedVersionStore.commit(hash, commitMessage, null);
    }

    protected static Commit commit(Hash hash, CommitMeta commitMessage, Hash parentHash) {
        ImmutableCommit.Builder builder = Commit.builder().hash(hash).commitMeta(commitMessage);
        if (parentHash != null) {
            builder.parentHash(parentHash);
        }
        return builder.build();
    }

    protected CommitBuilder forceCommit(String message) {
        return new CommitBuilder(this.store()).withMetadata(CommitMeta.fromMessage((String)message));
    }

    protected CommitBuilder commit(String message) {
        return new CommitBuilder(this.store()).withMetadata(CommitMeta.fromMessage((String)message)).fromLatest();
    }

    protected Put put(String key, Content value) {
        return Put.of((Key)Key.of((String[])new String[]{key}), (Content)value);
    }

    protected Delete delete(String key) {
        return Delete.of((Key)Key.of((String[])new String[]{key}));
    }

    protected Unchanged unchanged(String key) {
        return Unchanged.of((Key)Key.of((String[])new String[]{key}));
    }

    protected boolean filterMainBranch(ReferenceInfo<CommitMeta> r) {
        return !r.getNamedRef().getName().equals("main");
    }

    protected static void assertCommitMeta(SoftAssertions soft, List<Commit> current, List<Commit> expected, MetadataRewriter<CommitMeta> commitMetaModifier) {
        soft.assertThat(current).map(Commit::getCommitMeta).map(m -> CommitMeta.builder().from(m).hash(null).parentCommitHashes(Collections.emptyList()).build()).containsExactlyElementsOf((Iterable)expected.stream().map(Commit::getCommitMeta).map(arg_0 -> commitMetaModifier.rewriteSingle(arg_0)).collect(Collectors.toList()));
    }

    protected static Content contentWithoutId(Content content) {
        return content != null ? DefaultStoreWorker.instance().applyId(content, null) : null;
    }

    protected static Optional<Content> contentWithoutId(Optional<Content> content) {
        return content.map(AbstractNestedVersionStore::contentWithoutId);
    }

    protected static Map<Key, Content> contentsWithoutId(Map<Key, Content> valueMap) {
        return valueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractNestedVersionStore.contentWithoutId((Content)e.getValue())));
    }

    protected static List<Diff> diffsWithoutContentId(List<Diff> diffs) {
        return diffs.stream().map(d -> Diff.of((Key)d.getKey(), AbstractNestedVersionStore.contentWithoutId(d.getFromValue()), AbstractNestedVersionStore.contentWithoutId(d.getToValue()))).collect(Collectors.toList());
    }

    protected static List<Operation> operationsWithoutContentId(List<Operation> operations) {
        if (operations == null) {
            return null;
        }
        return operations.stream().map(op -> {
            if (op instanceof Put) {
                Put put = (Put)op;
                return put.getExpectedValue() != null ? Put.of((Key)put.getKey(), (Content)AbstractNestedVersionStore.contentWithoutId(put.getValue()), (Content)AbstractNestedVersionStore.contentWithoutId(put.getExpectedValue())) : Put.of((Key)put.getKey(), (Content)AbstractNestedVersionStore.contentWithoutId(put.getValue()));
            }
            return op;
        }).collect(Collectors.toList());
    }
}

