/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.ext;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.ext.MultiVersionApiTest;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieClientCustomizer;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.client.ext.NessieClientResponseFactory;
import org.projectnessie.client.ext.NessieClientUri;
import org.projectnessie.client.ext.NessieClientUriResolver;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.http.HttpResponseFactory;

public abstract class NessieClientResolver
implements ParameterResolver {
    protected abstract URI getBaseUri(ExtensionContext var1);

    private URI resolvedNessieUri(ExtensionContext extensionContext) {
        NessieClientUriResolver resolver = extensionContext.getTestInstance().filter(t -> t instanceof NessieClientUriResolver).map(NessieClientUriResolver.class::cast).orElse(NessieApiVersion::resolve);
        URI base = this.getBaseUri(extensionContext);
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
        return resolver.resolve(apiVersion, base);
    }

    private boolean isNessieUri(ParameterContext parameterContext) {
        return parameterContext.isAnnotated(NessieClientUri.class);
    }

    private boolean isNessieClient(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(NessieClientFactory.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.isNessieUri(parameterContext) || this.isNessieClient(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isNessieUri(parameterContext)) {
            return this.resolvedNessieUri(extensionContext);
        }
        if (this.isNessieClient(parameterContext)) {
            return this.clientFactoryForContext(extensionContext);
        }
        throw new IllegalStateException("Unsupported parameter: " + parameterContext);
    }

    private NessieClientFactory clientFactoryForContext(ExtensionContext extensionContext) {
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
        URI uri = this.resolvedNessieUri(extensionContext);
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        Class responseFactoryClass = extensionContext.getTestClass().flatMap(cl -> AnnotationUtils.findAnnotation((AnnotatedElement)cl, NessieClientResponseFactory.class)).map(NessieClientResponseFactory::value).orElse(null);
        if (testInstance instanceof NessieClientCustomizer) {
            final NessieClientCustomizer testCustomizer = testInstance;
            return new ClientFactory(uri, apiVersion, responseFactoryClass){

                @Override
                @javax.annotation.Nonnull
                @Nonnull
                public NessieApiV1 make(NessieClientCustomizer customizer) {
                    return super.make((builder, version) -> customizer.configure(testCustomizer.configure(builder, version), version));
                }
            };
        }
        return new ClientFactory(uri, apiVersion, responseFactoryClass);
    }

    private static class ClientFactory
    implements NessieClientFactory,
    Serializable {
        private final URI resolvedUri;
        private final NessieApiVersion apiVersion;
        private final Class<? extends HttpResponseFactory> responseFactoryClass;

        private ClientFactory(URI nessieUri, NessieApiVersion apiVersion, Class<? extends HttpResponseFactory> responseFactoryClass) {
            this.resolvedUri = nessieUri;
            this.apiVersion = apiVersion;
            this.responseFactoryClass = responseFactoryClass;
        }

        @Override
        public NessieApiVersion apiVersion() {
            return this.apiVersion;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public NessieApiV1 make(NessieClientCustomizer customizer) {
            HttpClientBuilder clientBuilder = HttpClientBuilder.builder().withUri(this.resolvedUri);
            if (this.responseFactoryClass != null) {
                try {
                    clientBuilder = clientBuilder.withResponseFactory(this.responseFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            NessieClientBuilder<?> builder = customizer.configure((NessieClientBuilder<?>)clientBuilder, this.apiVersion);
            return this.apiVersion.build(builder);
        }
    }
}

