/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.ext;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.projectnessie.client.config.NessieClientConfigSources;
import org.projectnessie.client.ext.MultiVersionApiTest;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieClientCustomizer;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.client.ext.NessieClientNameResolver;
import org.projectnessie.client.ext.NessieClientResponseFactory;
import org.projectnessie.client.ext.NessieClientUri;
import org.projectnessie.client.ext.NessieClientUriResolver;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.NessieHttpClientBuilder;

public abstract class NessieClientResolver
implements ParameterResolver {
    protected abstract URI getBaseUri(ExtensionContext var1);

    private URI resolvedNessieUri(ExtensionContext extensionContext) {
        NessieClientUriResolver resolver = extensionContext.getTestInstance().filter(t -> t instanceof NessieClientUriResolver).map(NessieClientUriResolver.class::cast).orElse(NessieApiVersion::resolve);
        URI base = this.getBaseUri(extensionContext);
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
        return resolver.resolve(apiVersion, base);
    }

    private boolean isNessieUri(ParameterContext parameterContext) {
        return parameterContext.isAnnotated(NessieClientUri.class);
    }

    private boolean isNessieClient(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(NessieClientFactory.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.isNessieUri(parameterContext) || this.isNessieClient(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isNessieUri(parameterContext)) {
            return this.resolvedNessieUri(extensionContext);
        }
        if (this.isNessieClient(parameterContext)) {
            return this.clientFactoryForContext(extensionContext);
        }
        throw new IllegalStateException("Unsupported parameter: " + String.valueOf(parameterContext));
    }

    private NessieClientFactory clientFactoryForContext(ExtensionContext extensionContext) {
        NessieClientConfigSource mainConfigSource = extensionContext.getTestInstance().filter(t -> t instanceof NessieClientNameResolver).map(NessieClientNameResolver.class::cast).map(NessieClientNameResolver::mainNessieClientConfigMap).map(NessieClientConfigSources::mapConfigSource).orElseGet(NessieClientConfigSources::emptyConfigSource);
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
        URI uri = this.resolvedNessieUri(extensionContext);
        List customizers = extensionContext.getTestInstances().map(i -> i.getAllInstances().stream().filter(ti -> ti instanceof NessieClientCustomizer).map(ti -> (NessieClientCustomizer)ti).collect(Collectors.toList())).orElse(Collections.emptyList());
        Class responseFactoryClass = extensionContext.getTestClass().flatMap(cl -> AnnotationUtils.findAnnotation((AnnotatedElement)cl, NessieClientResponseFactory.class)).map(NessieClientResponseFactory::value).orElse(null);
        if (!customizers.isEmpty()) {
            final NessieClientCustomizer testCustomizer = (builder, version) -> {
                for (NessieClientCustomizer customizer : customizers) {
                    builder = customizer.configure(builder, version);
                }
                return builder;
            };
            return new ClientFactory(uri, mainConfigSource, apiVersion, responseFactoryClass){

                @Override
                @javax.annotation.Nonnull
                @Nonnull
                public NessieApiV1 make(NessieClientCustomizer customizer) {
                    return super.make((builder, version) -> customizer.configure(testCustomizer.configure(builder, version), version));
                }
            };
        }
        return new ClientFactory(uri, mainConfigSource, apiVersion, responseFactoryClass);
    }

    private static class ClientFactory
    implements NessieClientFactory,
    Serializable {
        private final URI resolvedUri;
        private final NessieClientConfigSource mainConfigSource;
        private final NessieApiVersion apiVersion;
        private final Class<? extends HttpResponseFactory> responseFactoryClass;

        private ClientFactory(URI nessieUri, NessieClientConfigSource mainConfigSource, NessieApiVersion apiVersion, Class<? extends HttpResponseFactory> responseFactoryClass) {
            this.resolvedUri = nessieUri;
            this.mainConfigSource = mainConfigSource;
            this.apiVersion = apiVersion;
            this.responseFactoryClass = responseFactoryClass;
        }

        @Override
        public NessieApiVersion apiVersion() {
            return this.apiVersion;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public NessieApiV1 make(NessieClientCustomizer customizer) {
            NessieClientBuilder clientBuilder = NessieClientBuilder.createClientBuilderFromSystemSettings((NessieClientConfigSource)this.mainConfigSource).withUri(this.resolvedUri);
            if (this.responseFactoryClass != null) {
                try {
                    clientBuilder = ((NessieHttpClientBuilder)clientBuilder.asInstanceOf(NessieHttpClientBuilder.class)).withResponseFactory(this.responseFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            NessieClientBuilder builder = customizer.configure(clientBuilder, this.apiVersion);
            return this.apiVersion.build(builder);
        }
    }
}

