/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.PasswordTokenRequest;
import org.projectnessie.client.auth.oauth2.PasswordTokenResponse;
import org.projectnessie.client.auth.oauth2.Tokens;

class PasswordFlow
extends AbstractFlow {
    PasswordFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens ignored) {
        String username = this.config.getUsername().orElseThrow(() -> new IllegalStateException("Username is required"));
        String password = this.config.getPasswordSupplier().map(Supplier::get).orElseThrow(() -> new IllegalStateException("Password is required"));
        PasswordTokenRequest.Builder request = PasswordTokenRequest.builder().username(username).password(password);
        return this.invokeTokenEndpoint(request, PasswordTokenResponse.class);
    }
}

