/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenExchangeRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TokenExchangeRequest", generator="Immutables")
@Immutable
final class ImmutableTokenExchangeRequest
implements TokenExchangeRequest {
    @Nullable
    private final String scope;
    private final Map<String, String> extraParameters;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    @Nullable
    private final URI resource;
    @Nullable
    private final String audience;
    @Nullable
    private final URI requestedTokenType;
    private final String subjectToken;
    private final URI subjectTokenType;
    @Nullable
    private final String actorToken;
    @Nullable
    private final URI actorTokenType;

    private ImmutableTokenExchangeRequest(@Nullable String scope, Map<String, String> extraParameters, @Nullable String clientId, @Nullable URI resource, @Nullable String audience, @Nullable URI requestedTokenType, String subjectToken, URI subjectTokenType, @Nullable String actorToken, @Nullable URI actorTokenType) {
        this.scope = scope;
        this.extraParameters = extraParameters;
        this.clientId = clientId;
        this.resource = resource;
        this.audience = audience;
        this.requestedTokenType = requestedTokenType;
        this.subjectToken = subjectToken;
        this.subjectTokenType = subjectTokenType;
        this.actorToken = actorToken;
        this.actorTokenType = actorTokenType;
        this.grantType = Objects.requireNonNull(TokenExchangeRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, String> extraParameters() {
        return this.extraParameters;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="resource")
    @Nullable
    public URI getResource() {
        return this.resource;
    }

    @Override
    @JsonProperty(value="audience")
    @Nullable
    public String getAudience() {
        return this.audience;
    }

    @Override
    @JsonProperty(value="requested_token_type")
    @Nullable
    public URI getRequestedTokenType() {
        return this.requestedTokenType;
    }

    @Override
    @JsonProperty(value="subject_token")
    public String getSubjectToken() {
        return this.subjectToken;
    }

    @Override
    @JsonProperty(value="subject_token_type")
    public URI getSubjectTokenType() {
        return this.subjectTokenType;
    }

    @Override
    @JsonProperty(value="actor_token")
    @Nullable
    public String getActorToken() {
        return this.actorToken;
    }

    @Override
    @JsonProperty(value="actor_token_type")
    @Nullable
    public URI getActorTokenType() {
        return this.actorTokenType;
    }

    public final ImmutableTokenExchangeRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(value, this.extraParameters, this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withExtraParameters(Map<String, ? extends String> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableTokenExchangeRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableTokenExchangeRequest(this.scope, newValue, this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, value, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withResource(@Nullable URI value) {
        if (this.resource == value) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, value, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withAudience(@Nullable String value) {
        if (Objects.equals(this.audience, value)) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, value, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withRequestedTokenType(@Nullable URI value) {
        if (this.requestedTokenType == value) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, this.audience, value, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withSubjectToken(String value) {
        String newValue = Objects.requireNonNull(value, "subjectToken");
        if (this.subjectToken.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, this.audience, this.requestedTokenType, newValue, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withSubjectTokenType(URI value) {
        if (this.subjectTokenType == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "subjectTokenType");
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, newValue, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withActorToken(@Nullable String value) {
        if (Objects.equals(this.actorToken, value)) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, value, this.actorTokenType);
    }

    public final ImmutableTokenExchangeRequest withActorTokenType(@Nullable URI value) {
        if (this.actorTokenType == value) {
            return this;
        }
        return new ImmutableTokenExchangeRequest(this.scope, this.extraParameters, this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenExchangeRequest && this.equalTo(0, (ImmutableTokenExchangeRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokenExchangeRequest another) {
        return Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && Objects.equals(this.resource, another.resource) && Objects.equals(this.audience, another.audience) && Objects.equals(this.requestedTokenType, another.requestedTokenType) && this.subjectToken.equals(another.subjectToken) && this.subjectTokenType.equals(another.subjectTokenType) && Objects.equals(this.actorToken, another.actorToken) && Objects.equals(this.actorTokenType, another.actorTokenType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.extraParameters.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + Objects.hashCode(this.resource);
        h += (h << 5) + Objects.hashCode(this.audience);
        h += (h << 5) + Objects.hashCode(this.requestedTokenType);
        h += (h << 5) + this.subjectToken.hashCode();
        h += (h << 5) + this.subjectTokenType.hashCode();
        h += (h << 5) + Objects.hashCode(this.actorToken);
        h += (h << 5) + Objects.hashCode(this.actorTokenType);
        return h;
    }

    public String toString() {
        return "TokenExchangeRequest{scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + ", clientId=" + this.clientId + ", grantType=" + String.valueOf((Object)this.grantType) + ", resource=" + String.valueOf(this.resource) + ", audience=" + this.audience + ", requestedTokenType=" + String.valueOf(this.requestedTokenType) + ", subjectToken=" + this.subjectToken + ", subjectTokenType=" + String.valueOf(this.subjectTokenType) + ", actorToken=" + this.actorToken + ", actorTokenType=" + String.valueOf(this.actorTokenType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTokenExchangeRequest fromJson(Json json) {
        Builder builder = ImmutableTokenExchangeRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.extraParameters != null) {
            builder.putAllExtraParameters(json.extraParameters);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.resource != null) {
            builder.resource(json.resource);
        }
        if (json.audience != null) {
            builder.audience(json.audience);
        }
        if (json.requestedTokenType != null) {
            builder.requestedTokenType(json.requestedTokenType);
        }
        if (json.subjectToken != null) {
            builder.subjectToken(json.subjectToken);
        }
        if (json.subjectTokenType != null) {
            builder.subjectTokenType(json.subjectTokenType);
        }
        if (json.actorToken != null) {
            builder.actorToken(json.actorToken);
        }
        if (json.actorTokenType != null) {
            builder.actorTokenType(json.actorTokenType);
        }
        return builder.build();
    }

    public static ImmutableTokenExchangeRequest copyOf(TokenExchangeRequest instance) {
        if (instance instanceof ImmutableTokenExchangeRequest) {
            return (ImmutableTokenExchangeRequest)instance;
        }
        return ImmutableTokenExchangeRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="TokenExchangeRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TokenExchangeRequest.Builder {
        private static final long INIT_BIT_SUBJECT_TOKEN = 1L;
        private static final long INIT_BIT_SUBJECT_TOKEN_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        private Map<String, String> extraParameters = new LinkedHashMap<String, String>();
        @Nullable
        private String clientId;
        @Nullable
        private URI resource;
        @Nullable
        private String audience;
        @Nullable
        private URI requestedTokenType;
        @Nullable
        private String subjectToken;
        @Nullable
        private URI subjectTokenType;
        @Nullable
        private String actorToken;
        @Nullable
        private URI actorTokenType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenExchangeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    String clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenExchangeRequest) {
                URI actorTokenTypeValue;
                URI requestedTokenTypeValue;
                String actorTokenValue;
                URI resourceValue;
                instance = (TokenExchangeRequest)object;
                String audienceValue = instance.getAudience();
                if (audienceValue != null) {
                    this.audience(audienceValue);
                }
                this.subjectTokenType(instance.getSubjectTokenType());
                if ((bits & 1L) == 0L) {
                    String clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((resourceValue = instance.getResource()) != null) {
                    this.resource(resourceValue);
                }
                this.subjectToken(instance.getSubjectToken());
                if ((bits & 2L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                if ((actorTokenValue = instance.getActorToken()) != null) {
                    this.actorToken(actorTokenValue);
                }
                if ((requestedTokenTypeValue = instance.getRequestedTokenType()) != null) {
                    this.requestedTokenType(requestedTokenTypeValue);
                }
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((actorTokenTypeValue = instance.getActorTokenType()) != null) {
                    this.actorTokenType(actorTokenTypeValue);
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, String value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends String> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="resource")
        @CanIgnoreReturnValue
        public final Builder resource(@Nullable URI resource) {
            this.resource = resource;
            return this;
        }

        @Override
        @JsonProperty(value="audience")
        @CanIgnoreReturnValue
        public final Builder audience(@Nullable String audience) {
            this.audience = audience;
            return this;
        }

        @Override
        @JsonProperty(value="requested_token_type")
        @CanIgnoreReturnValue
        public final Builder requestedTokenType(@Nullable URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        @Override
        @JsonProperty(value="subject_token")
        @CanIgnoreReturnValue
        public final Builder subjectToken(String subjectToken) {
            this.subjectToken = Objects.requireNonNull(subjectToken, "subjectToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="subject_token_type")
        @CanIgnoreReturnValue
        public final Builder subjectTokenType(URI subjectTokenType) {
            this.subjectTokenType = Objects.requireNonNull(subjectTokenType, "subjectTokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="actor_token")
        @CanIgnoreReturnValue
        public final Builder actorToken(@Nullable String actorToken) {
            this.actorToken = actorToken;
            return this;
        }

        @Override
        @JsonProperty(value="actor_token_type")
        @CanIgnoreReturnValue
        public final Builder actorTokenType(@Nullable URI actorTokenType) {
            this.actorTokenType = actorTokenType;
            return this;
        }

        @Override
        public ImmutableTokenExchangeRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenExchangeRequest(this.scope, ImmutableTokenExchangeRequest.createUnmodifiableMap(false, false, this.extraParameters), this.clientId, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subjectToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("subjectTokenType");
            }
            return "Cannot build TokenExchangeRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TokenExchangeRequest", generator="Immutables")
    static final class Json
    implements TokenExchangeRequest {
        @Nullable
        String scope;
        @Nullable
        String clientId;
        @Nullable
        URI resource;
        @Nullable
        String audience;
        @Nullable
        URI requestedTokenType;
        @Nullable
        String subjectToken;
        @Nullable
        URI subjectTokenType;
        @Nullable
        String actorToken;
        @Nullable
        URI actorTokenType;
        final Map<String, String> extraParameters = new HashMap<String, String>();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="resource")
        public void setResource(@Nullable URI resource) {
            this.resource = resource;
        }

        @JsonProperty(value="audience")
        public void setAudience(@Nullable String audience) {
            this.audience = audience;
        }

        @JsonProperty(value="requested_token_type")
        public void setRequestedTokenType(@Nullable URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
        }

        @JsonProperty(value="subject_token")
        public void setSubjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
        }

        @JsonProperty(value="subject_token_type")
        public void setSubjectTokenType(URI subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
        }

        @JsonProperty(value="actor_token")
        public void setActorToken(@Nullable String actorToken) {
            this.actorToken = actorToken;
        }

        @JsonProperty(value="actor_token_type")
        public void setActorTokenType(@Nullable URI actorTokenType) {
            this.actorTokenType = actorTokenType;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, String value) {
            this.extraParameters.put(key, value);
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> extraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getResource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAudience() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getRequestedTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSubjectToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getSubjectTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActorToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getActorTokenType() {
            throw new UnsupportedOperationException();
        }
    }
}

