/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.ImpersonationConfig;
import org.projectnessie.client.auth.oauth2.Secret;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ImpersonationConfig", generator="Immutables")
@Immutable
public final class ImmutableImpersonationConfig
implements ImpersonationConfig {
    private final boolean enabled;
    private final String clientId;
    private final Secret clientSecret;
    private final Supplier<String> clientSecretSupplier;
    private final URI issuerUrl;
    private final URI tokenEndpoint;
    private final List<String> scopes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableImpersonationConfig(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientSecretSupplier = builder.clientSecretSupplier;
        this.issuerUrl = builder.issuerUrl;
        this.tokenEndpoint = builder.tokenEndpoint;
        if (builder.enabledIsSet()) {
            this.initShim.enabled(builder.enabled);
        }
        if (builder.scopesIsSet()) {
            this.initShim.scopes(ImmutableImpersonationConfig.createUnmodifiableList(true, builder.scopes));
        }
        this.enabled = this.initShim.isEnabled();
        this.scopes = this.initShim.getScopes();
        this.initShim = null;
    }

    private ImmutableImpersonationConfig(boolean enabled, String clientId, Secret clientSecret, Supplier<String> clientSecretSupplier, URI issuerUrl, URI tokenEndpoint, List<String> scopes) {
        this.enabled = enabled;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientSecretSupplier = clientSecretSupplier;
        this.issuerUrl = issuerUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.scopes = scopes;
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return ImpersonationConfig.super.isEnabled();
    }

    private List<String> getScopesInitialize() {
        return ImpersonationConfig.super.getScopes();
    }

    @Override
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.enabled;
    }

    @Override
    public Optional<String> getClientId() {
        return Optional.ofNullable(this.clientId);
    }

    @Override
    public Optional<Secret> getClientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    @Override
    public Optional<Supplier<String>> getClientSecretSupplier() {
        return Optional.ofNullable(this.clientSecretSupplier);
    }

    @Override
    public Optional<URI> getIssuerUrl() {
        return Optional.ofNullable(this.issuerUrl);
    }

    @Override
    public Optional<URI> getTokenEndpoint() {
        return Optional.ofNullable(this.tokenEndpoint);
    }

    @Override
    public List<String> getScopes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getScopes() : this.scopes;
    }

    public final ImmutableImpersonationConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableImpersonationConfig(value, this.clientId, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (Objects.equals(this.clientId, newValue)) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, newValue, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, value, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientSecret(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret == newValue) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, newValue, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientSecret(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.clientSecret == value) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, value, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientSecretSupplier(Supplier<String> value) {
        Supplier<String> newValue = Objects.requireNonNull(value, "clientSecretSupplier");
        if (this.clientSecretSupplier == newValue) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, newValue, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withClientSecretSupplier(Optional<? extends Supplier<String>> optional) {
        Supplier value = optional.orElse(null);
        if (this.clientSecretSupplier == value) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, value, this.issuerUrl, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withIssuerUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "issuerUrl");
        if (this.issuerUrl == newValue) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, newValue, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withIssuerUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.issuerUrl == value) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, value, this.tokenEndpoint, this.scopes);
    }

    public final ImmutableImpersonationConfig withTokenEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "tokenEndpoint");
        if (this.tokenEndpoint == newValue) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, newValue, this.scopes);
    }

    public final ImmutableImpersonationConfig withTokenEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.tokenEndpoint == value) {
            return this;
        }
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, value, this.scopes);
    }

    public final ImmutableImpersonationConfig withScopes(String ... elements) {
        List<String> newValue = ImmutableImpersonationConfig.createUnmodifiableList(false, ImmutableImpersonationConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, newValue);
    }

    public final ImmutableImpersonationConfig withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableImpersonationConfig.createUnmodifiableList(false, ImmutableImpersonationConfig.createSafeList(elements, true, false));
        return new ImmutableImpersonationConfig(this.enabled, this.clientId, this.clientSecret, this.clientSecretSupplier, this.issuerUrl, this.tokenEndpoint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImpersonationConfig && this.equalTo(0, (ImmutableImpersonationConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableImpersonationConfig another) {
        return this.enabled == another.enabled && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.clientSecretSupplier, another.clientSecretSupplier) && Objects.equals(this.issuerUrl, another.issuerUrl) && Objects.equals(this.tokenEndpoint, another.tokenEndpoint) && this.scopes.equals(another.scopes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + Objects.hashCode(this.clientSecretSupplier);
        h += (h << 5) + Objects.hashCode(this.issuerUrl);
        h += (h << 5) + Objects.hashCode(this.tokenEndpoint);
        h += (h << 5) + this.scopes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ImpersonationConfig{");
        builder.append("enabled=").append(this.enabled);
        if (this.clientId != null) {
            builder.append(", ");
            builder.append("clientId=").append(this.clientId);
        }
        if (this.issuerUrl != null) {
            builder.append(", ");
            builder.append("issuerUrl=").append(this.issuerUrl);
        }
        if (this.tokenEndpoint != null) {
            builder.append(", ");
            builder.append("tokenEndpoint=").append(this.tokenEndpoint);
        }
        builder.append(", ");
        builder.append("scopes=").append(this.scopes);
        return builder.append("}").toString();
    }

    public static ImmutableImpersonationConfig copyOf(ImpersonationConfig instance) {
        if (instance instanceof ImmutableImpersonationConfig) {
            return (ImmutableImpersonationConfig)instance;
        }
        return ImmutableImpersonationConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ImpersonationConfig", generator="Immutables")
    private final class InitShim {
        private byte enabledBuildStage = 0;
        private boolean enabled;
        private byte scopesBuildStage = 0;
        private List<String> scopes;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.enabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enabledBuildStage == 0) {
                this.enabledBuildStage = (byte)-1;
                this.enabled = ImmutableImpersonationConfig.this.isEnabledInitialize();
                this.enabledBuildStage = 1;
            }
            return this.enabled;
        }

        void enabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledBuildStage = 1;
        }

        List<String> getScopes() {
            if (this.scopesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopesBuildStage == 0) {
                this.scopesBuildStage = (byte)-1;
                this.scopes = ImmutableImpersonationConfig.createUnmodifiableList(false, ImmutableImpersonationConfig.createSafeList(ImmutableImpersonationConfig.this.getScopesInitialize(), true, false));
                this.scopesBuildStage = 1;
            }
            return this.scopes;
        }

        void scopes(List<String> scopes) {
            this.scopes = scopes;
            this.scopesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.enabledBuildStage == -1) {
                attributes.add("enabled");
            }
            if (this.scopesBuildStage == -1) {
                attributes.add("scopes");
            }
            return "Cannot build ImpersonationConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="ImpersonationConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ImpersonationConfig.Builder {
        private static final long OPT_BIT_ENABLED = 1L;
        private static final long OPT_BIT_SCOPES = 2L;
        private long optBits;
        private boolean enabled;
        private String clientId;
        private Secret clientSecret;
        private Supplier<String> clientSecretSupplier;
        private URI issuerUrl;
        private URI tokenEndpoint;
        private List<String> scopes = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ImpersonationConfig instance) {
            Optional<URI> tokenEndpointOptional;
            Optional<URI> issuerUrlOptional;
            Optional<Supplier<String>> clientSecretSupplierOptional;
            Optional<Secret> clientSecretOptional;
            Objects.requireNonNull(instance, "instance");
            this.enabled(instance.isEnabled());
            Optional<String> clientIdOptional = instance.getClientId();
            if (clientIdOptional.isPresent()) {
                this.clientId(clientIdOptional);
            }
            if ((clientSecretOptional = instance.getClientSecret()).isPresent()) {
                this.clientSecret(clientSecretOptional);
            }
            if ((clientSecretSupplierOptional = instance.getClientSecretSupplier()).isPresent()) {
                this.clientSecretSupplier(clientSecretSupplierOptional);
            }
            if ((issuerUrlOptional = instance.getIssuerUrl()).isPresent()) {
                this.issuerUrl(issuerUrlOptional);
            }
            if ((tokenEndpointOptional = instance.getTokenEndpoint()).isPresent()) {
                this.tokenEndpoint(tokenEndpointOptional);
            }
            this.addAllScopes(instance.getScopes());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(Optional<String> clientId) {
            this.clientId = clientId.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecret(Secret clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<? extends Secret> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Supplier<String> clientSecretSupplier) {
            this.clientSecretSupplier = Objects.requireNonNull(clientSecretSupplier, "clientSecretSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Optional<? extends Supplier<String>> clientSecretSupplier) {
            this.clientSecretSupplier = clientSecretSupplier.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder issuerUrl(URI issuerUrl) {
            this.issuerUrl = Objects.requireNonNull(issuerUrl, "issuerUrl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuerUrl(Optional<? extends URI> issuerUrl) {
            this.issuerUrl = issuerUrl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(Optional<? extends URI> tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableImpersonationConfig build() {
            return new ImmutableImpersonationConfig(this);
        }

        private boolean enabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean scopesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

