/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.DeleteNamespaceResult;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteNamespaceResult", generator="Immutables")
@Immutable
public final class ImmutableDeleteNamespaceResult
implements DeleteNamespaceResult {
    private final Namespace namespace;
    private final Branch effectiveBranch;

    private ImmutableDeleteNamespaceResult(Namespace namespace, Branch effectiveBranch) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
    }

    private ImmutableDeleteNamespaceResult(ImmutableDeleteNamespaceResult original, Namespace namespace, Branch effectiveBranch) {
        this.namespace = namespace;
        this.effectiveBranch = effectiveBranch;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Branch getEffectiveBranch() {
        return this.effectiveBranch;
    }

    public final ImmutableDeleteNamespaceResult withNamespace(Namespace value) {
        if (this.namespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespace");
        return new ImmutableDeleteNamespaceResult(this, newValue, this.effectiveBranch);
    }

    public final ImmutableDeleteNamespaceResult withEffectiveBranch(Branch value) {
        if (this.effectiveBranch == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "effectiveBranch");
        return new ImmutableDeleteNamespaceResult(this, this.namespace, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteNamespaceResult && this.equalsByValue((ImmutableDeleteNamespaceResult)another);
    }

    private boolean equalsByValue(ImmutableDeleteNamespaceResult another) {
        return this.namespace.equals(another.namespace) && this.effectiveBranch.equals((Object)another.effectiveBranch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + this.effectiveBranch.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteNamespaceResult{namespace=" + String.valueOf(this.namespace) + ", effectiveBranch=" + String.valueOf(this.effectiveBranch) + "}";
    }

    public static ImmutableDeleteNamespaceResult of(Namespace namespace, Branch effectiveBranch) {
        return new ImmutableDeleteNamespaceResult(namespace, effectiveBranch);
    }

    public static ImmutableDeleteNamespaceResult copyOf(DeleteNamespaceResult instance) {
        if (instance instanceof ImmutableDeleteNamespaceResult) {
            return (ImmutableDeleteNamespaceResult)instance;
        }
        return ImmutableDeleteNamespaceResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteNamespaceResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long INIT_BIT_EFFECTIVE_BRANCH = 2L;
        private long initBits = 3L;
        private Namespace namespace;
        private Branch effectiveBranch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteNamespaceResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namespace(instance.getNamespace());
            this.effectiveBranch(instance.getEffectiveBranch());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder effectiveBranch(Branch effectiveBranch) {
            this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteNamespaceResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteNamespaceResult(null, this.namespace, this.effectiveBranch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("effectiveBranch");
            }
            return "Cannot build DeleteNamespaceResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

