/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.Token;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccessToken", generator="Immutables")
@Immutable
public final class ImmutableAccessToken
implements AccessToken {
    private final String payload;
    @Nullable
    private final Instant expirationTime;
    private final String tokenType;

    private ImmutableAccessToken(String payload, @Nullable Instant expirationTime, String tokenType) {
        this.payload = payload;
        this.expirationTime = expirationTime;
        this.tokenType = tokenType;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    public final ImmutableAccessToken withPayload(String value) {
        String newValue = Objects.requireNonNull(value, "payload");
        if (this.payload.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessToken(newValue, this.expirationTime, this.tokenType);
    }

    public final ImmutableAccessToken withExpirationTime(@Nullable Instant value) {
        if (this.expirationTime == value) {
            return this;
        }
        return new ImmutableAccessToken(this.payload, value, this.tokenType);
    }

    public final ImmutableAccessToken withTokenType(String value) {
        String newValue = Objects.requireNonNull(value, "tokenType");
        if (this.tokenType.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessToken(this.payload, this.expirationTime, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessToken && this.equalTo(0, (ImmutableAccessToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessToken another) {
        return this.payload.equals(another.payload) && Objects.equals(this.expirationTime, another.expirationTime) && this.tokenType.equals(another.tokenType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.payload.hashCode();
        h += (h << 5) + Objects.hashCode(this.expirationTime);
        h += (h << 5) + this.tokenType.hashCode();
        return h;
    }

    public String toString() {
        return "AccessToken{payload=" + this.payload + ", expirationTime=" + String.valueOf(this.expirationTime) + ", tokenType=" + this.tokenType + "}";
    }

    public static ImmutableAccessToken copyOf(AccessToken instance) {
        if (instance instanceof ImmutableAccessToken) {
            return (ImmutableAccessToken)instance;
        }
        return ImmutableAccessToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_TOKEN_TYPE = 2L;
        private long initBits = 3L;
        private String payload;
        private Instant expirationTime;
        private String tokenType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Token instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Instant expirationTimeValue;
            Token instance;
            long bits = 0L;
            if (object instanceof AccessToken) {
                instance = (AccessToken)object;
                this.tokenType(instance.getTokenType());
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof Token) {
                instance = (Token)object;
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expirationTime(@Nullable Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAccessToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccessToken(this.payload, this.expirationTime, this.tokenType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenType");
            }
            return "Cannot build AccessToken, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

