/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk11.JavaRequest;

final class JavaHttpClient
implements HttpClient {
    final HttpRuntimeConfig config;
    private java.net.http.HttpClient client;
    private final ForkJoinPool writerPool;

    JavaHttpClient(HttpRuntimeConfig config) {
        this.config = config;
        HttpClient.Builder clientBuilder = java.net.http.HttpClient.newBuilder().connectTimeout(Duration.ofMillis(config.getConnectionTimeoutMillis()));
        if (config.getSslContext() != null) {
            clientBuilder.sslContext(config.getSslContext());
        }
        if (config.getSslParameters() != null) {
            clientBuilder.sslParameters(config.getSslParameters());
        }
        if (config.getFollowRedirects() != null) {
            clientBuilder.followRedirects(HttpClient.Redirect.valueOf(config.getFollowRedirects().toUpperCase(Locale.ROOT)));
        }
        if (config.isHttp11Only()) {
            clientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        this.client = clientBuilder.build();
        this.writerPool = new ForkJoinPool(Math.max(8, ForkJoinPool.getCommonPoolParallelism()));
    }

    @Override
    public HttpRequest newRequest(URI baseUri) {
        return new JavaRequest(this.config, baseUri, this.client::send, this.writerPool);
    }

    @Override
    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Exception fail = null;
        try {
            if (this.client instanceof AutoCloseable) {
                ((AutoCloseable)this.client).close();
            }
        }
        catch (Exception e) {
            fail = e;
        }
        finally {
            this.client = null;
        }
        try {
            this.config.close();
        }
        catch (Exception e) {
            if (fail == null) {
                fail = e;
            } else {
                fail.addSuppressed(e);
            }
        }
        finally {
            try {
                this.writerPool.shutdown();
                try {
                    this.writerPool.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                if (fail == null) {
                    fail = e;
                }
                fail.addSuppressed(e);
            }
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        if (fail != null) {
            throw new RuntimeException(fail);
        }
    }
}

