/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.RefreshTokenRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefreshTokenRequest", generator="Immutables")
@Immutable
final class ImmutableRefreshTokenRequest
implements RefreshTokenRequest {
    @Nullable
    private final String scope;
    private final Map<String, String> extraParameters;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String refreshToken;

    private ImmutableRefreshTokenRequest(@Nullable String scope, Map<String, String> extraParameters, @Nullable String clientId, String refreshToken) {
        this.scope = scope;
        this.extraParameters = extraParameters;
        this.clientId = clientId;
        this.refreshToken = refreshToken;
        this.grantType = Objects.requireNonNull(RefreshTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters", required=true)
    @JsonAnyGetter
    public Map<String, String> extraParameters() {
        return this.extraParameters;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType", required=true)
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public final ImmutableRefreshTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableRefreshTokenRequest(value, this.extraParameters, this.clientId, this.refreshToken);
    }

    public final ImmutableRefreshTokenRequest withExtraParameters(Map<String, ? extends String> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRefreshTokenRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableRefreshTokenRequest(this.scope, newValue, this.clientId, this.refreshToken);
    }

    public final ImmutableRefreshTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableRefreshTokenRequest(this.scope, this.extraParameters, value, this.refreshToken);
    }

    public final ImmutableRefreshTokenRequest withRefreshToken(String value) {
        String newValue = Objects.requireNonNull(value, "refreshToken");
        if (this.refreshToken.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshTokenRequest(this.scope, this.extraParameters, this.clientId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefreshTokenRequest && this.equalsByValue((ImmutableRefreshTokenRequest)another);
    }

    private boolean equalsByValue(ImmutableRefreshTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.refreshToken.equals(another.refreshToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.extraParameters.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.refreshToken.hashCode();
        return h;
    }

    public String toString() {
        return "RefreshTokenRequest{scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + ", clientId=" + this.clientId + ", grantType=" + String.valueOf((Object)this.grantType) + ", refreshToken=" + this.refreshToken + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableRefreshTokenRequest fromJson(Json json) {
        Builder builder = ImmutableRefreshTokenRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.extraParameters != null) {
            builder.putAllExtraParameters(json.extraParameters);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.refreshToken != null) {
            builder.refreshToken(json.refreshToken);
        }
        return builder.build();
    }

    public static ImmutableRefreshTokenRequest copyOf(RefreshTokenRequest instance) {
        if (instance instanceof ImmutableRefreshTokenRequest) {
            return (ImmutableRefreshTokenRequest)instance;
        }
        return ImmutableRefreshTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RefreshTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RefreshTokenRequest.Builder {
        private static final long INIT_BIT_REFRESH_TOKEN = 1L;
        private long initBits = 1L;
        private String scope;
        private Map<String, String> extraParameters = new LinkedHashMap<String, String>();
        private String clientId;
        private String refreshToken;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RefreshTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof RefreshTokenRequest) {
                instance = (RefreshTokenRequest)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                this.refreshToken(instance.getRefreshToken());
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, String value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters", required=true)
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends String> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableRefreshTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefreshTokenRequest(this.scope, ImmutableRefreshTokenRequest.createUnmodifiableMap(false, false, this.extraParameters), this.clientId, this.refreshToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refreshToken");
            }
            return "Cannot build RefreshTokenRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="RefreshTokenRequest", generator="Immutables")
    static final class Json
    implements RefreshTokenRequest {
        @JsonIgnore
        String scope;
        @JsonIgnore
        String clientId;
        @JsonIgnore
        String refreshToken;
        @JsonIgnore
        final Map<String, String> extraParameters = new HashMap<String, String>();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, String value) {
            this.extraParameters.put(key, value);
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> extraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefreshToken() {
            throw new UnsupportedOperationException();
        }
    }
}

