/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.client.rest.io.CapturingInputStream;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieUnavailableException;

public class ResponseCheckFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void checkResponse(ResponseContext con) throws Exception {
        NessieServiceException exception;
        NessieError error;
        Status status = con.getStatus();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getInputStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, MAPPER.reader());
        }
        Optional modelException = ErrorCode.asException((NessieError)error);
        if (modelException.isPresent()) {
            throw (Exception)modelException.get();
        }
        switch (status.getCode()) {
            case 500: {
                exception = new NessieInternalServerException(error);
                break;
            }
            case 503: {
                exception = new NessieUnavailableException(error);
                break;
            }
            case 401: {
                exception = new NessieNotAuthorizedException(error);
                break;
            }
            default: {
                exception = new NessieServiceException(error);
            }
        }
        throw exception;
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        ImmutableNessieError error;
        if (inputStream == null) {
            error = ImmutableNessieError.builder().errorCode(ErrorCode.UNKNOWN).status(status.getCode()).reason(status.getReason()).message("Could not parse error object in response.").clientProcessingError("Could not parse error object in response.").build();
        } else {
            CapturingInputStream capturing = new CapturingInputStream(inputStream);
            try {
                JsonNode errorData = reader.readTree((InputStream)capturing);
                error = (NessieError)reader.treeToValue((TreeNode)errorData, NessieError.class);
                if (error == null) {
                    error = ResponseCheckFilter.noResponseError(status, "(no response from server)", "");
                }
            }
            catch (IOException e) {
                String cap = capturing.captured().trim();
                error = ResponseCheckFilter.noResponseError(status, e.toString(), cap);
            }
        }
        return error;
    }

    private static ImmutableNessieError noResponseError(Status status, String clientProcessingError, String cap) {
        return ImmutableNessieError.builder().message((String)(cap.isEmpty() ? "got empty response body from server" : "Could not parse error object in response beginning with: " + cap)).status(status.getCode()).reason(status.getReason()).clientProcessingError(clientProcessingError).build();
    }
}

