/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.ClientCredentialsTokenRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
@Immutable
final class ImmutableClientCredentialsTokenRequest
implements ClientCredentialsTokenRequest {
    @Nullable
    private final String scope;
    private final Map<String, String> extraParameters;
    private final transient GrantType grantType;

    private ImmutableClientCredentialsTokenRequest(@Nullable String scope, Map<String, String> extraParameters) {
        this.scope = scope;
        this.extraParameters = extraParameters;
        this.grantType = Objects.requireNonNull(ClientCredentialsTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, String> extraParameters() {
        return this.extraParameters;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    public final ImmutableClientCredentialsTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableClientCredentialsTokenRequest(value, this.extraParameters);
    }

    public final ImmutableClientCredentialsTokenRequest withExtraParameters(Map<String, ? extends String> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableClientCredentialsTokenRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableClientCredentialsTokenRequest(this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCredentialsTokenRequest && this.equalsByValue((ImmutableClientCredentialsTokenRequest)another);
    }

    private boolean equalsByValue(ImmutableClientCredentialsTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters) && this.grantType.equals((Object)another.grantType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.extraParameters.hashCode();
        h += (h << 5) + this.grantType.hashCode();
        return h;
    }

    public String toString() {
        return "ClientCredentialsTokenRequest{scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + ", grantType=" + String.valueOf((Object)this.grantType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClientCredentialsTokenRequest fromJson(Json json) {
        Builder builder = ImmutableClientCredentialsTokenRequest.builder();
        if (json._scope != null) {
            builder.scope(json._scope);
        }
        if (json._extraParameters != null) {
            builder.putAllExtraParameters(json._extraParameters);
        }
        return builder.build();
    }

    public static ImmutableClientCredentialsTokenRequest copyOf(ClientCredentialsTokenRequest instance) {
        if (instance instanceof ImmutableClientCredentialsTokenRequest) {
            return (ImmutableClientCredentialsTokenRequest)instance;
        }
        return ImmutableClientCredentialsTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ClientCredentialsTokenRequest.Builder {
        private String scope;
        private Map<String, String> extraParameters = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientCredentialsTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String scopeValue;
            TokenRequestBase instance;
            long bits = 0L;
            if (object instanceof ClientCredentialsTokenRequest) {
                instance = (ClientCredentialsTokenRequest)object;
                if ((bits & 2L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, String value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends String> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableClientCredentialsTokenRequest build() {
            return new ImmutableClientCredentialsTokenRequest(this.scope, ImmutableClientCredentialsTokenRequest.createUnmodifiableMap(false, false, this.extraParameters));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
    static final class Json
    implements ClientCredentialsTokenRequest {
        @JsonIgnore
        String _scope;
        @JsonIgnore
        final Map<String, String> _extraParameters = new HashMap<String, String>();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this._scope = scope;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, String value) {
            this._extraParameters.put(key, value);
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> extraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }
    }
}

