/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import java.util.Optional;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.CreateReferenceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.GetReferenceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.rest.v1.HttpAssignBranch;
import org.projectnessie.client.rest.v1.HttpAssignTag;
import org.projectnessie.client.rest.v1.HttpCommitMultipleOperations;
import org.projectnessie.client.rest.v1.HttpCreateNamespace;
import org.projectnessie.client.rest.v1.HttpCreateReference;
import org.projectnessie.client.rest.v1.HttpDeleteBranch;
import org.projectnessie.client.rest.v1.HttpDeleteNamespace;
import org.projectnessie.client.rest.v1.HttpDeleteTag;
import org.projectnessie.client.rest.v1.HttpGetAllReferences;
import org.projectnessie.client.rest.v1.HttpGetCommitLog;
import org.projectnessie.client.rest.v1.HttpGetContent;
import org.projectnessie.client.rest.v1.HttpGetDiff;
import org.projectnessie.client.rest.v1.HttpGetEntries;
import org.projectnessie.client.rest.v1.HttpGetMultipleNamespaces;
import org.projectnessie.client.rest.v1.HttpGetNamespace;
import org.projectnessie.client.rest.v1.HttpGetReference;
import org.projectnessie.client.rest.v1.HttpMergeReference;
import org.projectnessie.client.rest.v1.HttpTransplantCommits;
import org.projectnessie.client.rest.v1.HttpUpdateNamespace;
import org.projectnessie.client.rest.v1.NessieApiClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.NessieConfiguration;

public final class HttpApiV1
implements NessieApiV1 {
    private final NessieApiClient client;

    public HttpApiV1(NessieApiClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public <C> Optional<C> unwrapClient(Class<C> clientType) {
        return clientType.isAssignableFrom(HttpClient.class) ? this.client.httpClient().map(clientType::cast) : Optional.empty();
    }

    @Override
    public NessieConfiguration getConfig() {
        return this.client.getConfigApi().getConfig();
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        return this.client.getTreeApi().getDefaultBranch();
    }

    @Override
    public GetContentBuilder getContent() {
        return new HttpGetContent(this.client);
    }

    @Override
    public GetAllReferencesBuilder getAllReferences() {
        return new HttpGetAllReferences(this.client);
    }

    @Override
    public GetReferenceBuilder getReference() {
        return new HttpGetReference(this.client);
    }

    @Override
    public CreateReferenceBuilder createReference() {
        return new HttpCreateReference(this.client);
    }

    @Override
    public GetEntriesBuilder getEntries() {
        return new HttpGetEntries(this.client);
    }

    @Override
    public GetCommitLogBuilder getCommitLog() {
        return new HttpGetCommitLog(this.client);
    }

    @Override
    public AssignTagBuilder assignTag() {
        return new HttpAssignTag(this.client);
    }

    @Override
    public DeleteTagBuilder deleteTag() {
        return new HttpDeleteTag(this.client);
    }

    @Override
    public AssignBranchBuilder assignBranch() {
        return new HttpAssignBranch(this.client);
    }

    @Override
    public DeleteBranchBuilder deleteBranch() {
        return new HttpDeleteBranch(this.client);
    }

    @Override
    public TransplantCommitsBuilder transplantCommitsIntoBranch() {
        return new HttpTransplantCommits(this.client);
    }

    @Override
    public MergeReferenceBuilder mergeRefIntoBranch() {
        return new HttpMergeReference(this.client);
    }

    @Override
    public CommitMultipleOperationsBuilder commitMultipleOperations() {
        return new HttpCommitMultipleOperations(this.client);
    }

    @Override
    public GetDiffBuilder getDiff() {
        return new HttpGetDiff(this.client);
    }

    @Override
    @Deprecated
    public GetRefLogBuilder getRefLog() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GetNamespaceBuilder getNamespace() {
        return new HttpGetNamespace(this.client);
    }

    @Override
    public GetMultipleNamespacesBuilder getMultipleNamespaces() {
        return new HttpGetMultipleNamespaces(this.client);
    }

    @Override
    public CreateNamespaceBuilder createNamespace() {
        return new HttpCreateNamespace(this.client);
    }

    @Override
    public DeleteNamespaceBuilder deleteNamespace() {
        return new HttpDeleteNamespace(this.client);
    }

    @Override
    public UpdateNamespaceBuilder updateProperties() {
        return new HttpUpdateNamespace(this.client);
    }
}

