/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.ImmutableHttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk11.JavaHttpClient;
import org.projectnessie.client.http.impl.jdk8.UrlConnectionClient;

public interface HttpClient {
    public HttpRequest newRequest();

    public static Builder builder() {
        return new Builder();
    }

    public URI getBaseUri();

    public static class Builder {
        private URI baseUri;
        private ObjectMapper mapper;
        private Class<?> jsonView;
        private HttpResponseFactory responseFactory = HttpResponse::new;
        private SSLContext sslContext;
        private SSLParameters sslParameters;
        private int readTimeoutMillis = Integer.getInteger("sun.net.client.defaultReadTimeout", 25000);
        private int connectionTimeoutMillis = Integer.getInteger("sun.net.client.defaultConnectionTimeout", 5000);
        private boolean disableCompression;
        private final List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();
        private boolean http2Upgrade;
        private String followRedirects;
        private boolean forceUrlConnectionClient;

        private Builder() {
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public Builder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder setDisableCompression(boolean disableCompression) {
            this.disableCompression = disableCompression;
            return this;
        }

        public Builder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setJsonView(Class<?> jsonView) {
            this.jsonView = jsonView;
            return this;
        }

        public void setResponseFactory(HttpResponseFactory responseFactory) {
            this.responseFactory = responseFactory;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder setHttp2Upgrade(boolean http2Upgrade) {
            this.http2Upgrade = http2Upgrade;
            return this;
        }

        public Builder setFollowRedirects(String followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setForceUrlConnectionClient(boolean forceUrlConnectionClient) {
            this.forceUrlConnectionClient = forceUrlConnectionClient;
            return this;
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder addRequestFilter(RequestFilter filter) {
            this.requestFilters.add(filter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter filter) {
            this.responseFilters.add(filter);
            return this;
        }

        public HttpClient build() {
            HttpUtils.checkArgument(this.baseUri != null, "Cannot construct Http client. Must have a non-null uri", new Object[0]);
            HttpUtils.checkArgument(this.mapper != null, "Cannot construct Http client. Must have a non-null object mapper", new Object[0]);
            if (this.sslContext == null) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new HttpClientException("Cannot construct Http Client. Default SSL config is invalid.", e);
                }
            }
            ImmutableHttpRuntimeConfig config = HttpRuntimeConfig.builder().baseUri(this.baseUri).mapper(this.mapper).jsonView(this.jsonView).responseFactory(this.responseFactory).readTimeoutMillis(this.readTimeoutMillis).connectionTimeoutMillis(this.connectionTimeoutMillis).isDisableCompression(this.disableCompression).sslContext(this.sslContext).sslParameters(this.sslParameters).addAllRequestFilters(this.requestFilters).addAllResponseFilters(this.responseFilters).isHttp11Only(!this.http2Upgrade).followRedirects(this.followRedirects).forceUrlConnectionClient(this.forceUrlConnectionClient).build();
            return ImplSwitch.FACTORY.apply(config);
        }

        static class ImplSwitch {
            static final Function<HttpRuntimeConfig, HttpClient> FACTORY;

            ImplSwitch() {
            }

            static {
                Function<HttpRuntimeConfig, HttpClient> factory;
                try {
                    Class.forName("java.net.http.HttpClient");
                    factory = config -> Boolean.getBoolean("nessie.client.force-url-connection-client") || config.forceUrlConnectionClient() ? new UrlConnectionClient((HttpRuntimeConfig)config) : new JavaHttpClient((HttpRuntimeConfig)config);
                }
                catch (ClassNotFoundException e) {
                    factory = UrlConnectionClient::new;
                }
                FACTORY = factory;
            }
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

