/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v2api;

import org.projectnessie.api.v2.params.ImmutableMerge;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.builder.BaseMergeReferenceBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Reference;

final class HttpMergeReference
extends BaseMergeReferenceBuilder {
    private final HttpClient client;

    public HttpMergeReference(HttpClient client) {
        this.client = client;
    }

    @Override
    public MergeReferenceBuilder keepIndividualCommits(boolean keepIndividualCommits) {
        if (keepIndividualCommits) {
            throw new IllegalArgumentException("Commits are always squashed during merge operations.");
        }
        return this;
    }

    @Override
    public MergeResponse merge() throws NessieNotFoundException, NessieConflictException {
        ImmutableMerge.Builder merge = ImmutableMerge.builder().fromHash(this.fromHash).fromRefName(this.fromRefName).message(this.message).isDryRun(this.dryRun).isFetchAdditionalInfo(this.fetchAdditionalInfo).isReturnConflictAsResult(this.returnConflictAsResult);
        if (this.defaultMergeMode != null) {
            merge.defaultKeyMergeMode(this.defaultMergeMode);
        }
        if (this.mergeModes != null) {
            merge.keyMergeModes(this.mergeModes.values());
        }
        return this.client.newRequest().path("trees/{ref}/history/merge").resolveTemplate("ref", Reference.toPathString((String)this.branchName, (String)this.hash)).unwrap(NessieNotFoundException.class, NessieConflictException.class).post(merge.build()).readEntity(MergeResponse.class);
    }
}

