/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.builder.BaseOnReferenceBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.EntriesResponse;

public abstract class BaseGetEntriesBuilder<PARAMS>
extends BaseOnReferenceBuilder<GetEntriesBuilder>
implements GetEntriesBuilder {
    private final BiFunction<PARAMS, String, PARAMS> paramsForPage;
    private String pageToken;
    protected Integer maxRecords;
    protected String filter;
    protected Integer namespaceDepth;
    protected boolean withContent;

    protected BaseGetEntriesBuilder(BiFunction<PARAMS, String, PARAMS> paramsForPage) {
        this.paramsForPage = paramsForPage;
    }

    @Override
    public GetEntriesBuilder maxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    @Override
    public GetEntriesBuilder pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Override
    public GetEntriesBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public GetEntriesBuilder namespaceDepth(Integer namespaceDepth) {
        this.namespaceDepth = namespaceDepth;
        return this;
    }

    @Override
    public GetEntriesBuilder withContent(boolean withContent) {
        this.withContent = withContent;
        return this;
    }

    protected abstract PARAMS params();

    protected abstract EntriesResponse get(PARAMS var1) throws NessieNotFoundException;

    @Override
    public EntriesResponse get() throws NessieNotFoundException {
        return this.get(this.paramsForPage.apply(this.params(), this.pageToken));
    }

    @Override
    public Stream<EntriesResponse.Entry> stream() throws NessieNotFoundException {
        PARAMS p = this.params();
        return StreamingUtil.generateStream(EntriesResponse::getEntries, pageToken -> this.get(this.paramsForPage.apply(p, pageToken)));
    }
}

