/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v2api;

import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.CreateReferenceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.GetReferenceBuilder;
import org.projectnessie.client.api.GetRepositoryConfigBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.v2api.HttpAssignBranch;
import org.projectnessie.client.http.v2api.HttpAssignTag;
import org.projectnessie.client.http.v2api.HttpCommitMultipleOperations;
import org.projectnessie.client.http.v2api.HttpCreateReference;
import org.projectnessie.client.http.v2api.HttpDeleteBranch;
import org.projectnessie.client.http.v2api.HttpDeleteTag;
import org.projectnessie.client.http.v2api.HttpGetAllReferences;
import org.projectnessie.client.http.v2api.HttpGetCommitLog;
import org.projectnessie.client.http.v2api.HttpGetContent;
import org.projectnessie.client.http.v2api.HttpGetDiff;
import org.projectnessie.client.http.v2api.HttpGetEntries;
import org.projectnessie.client.http.v2api.HttpGetReference;
import org.projectnessie.client.http.v2api.HttpGetRepositoryConfig;
import org.projectnessie.client.http.v2api.HttpMergeReference;
import org.projectnessie.client.http.v2api.HttpTransplantCommits;
import org.projectnessie.client.http.v2api.HttpUpdateRepositoryConfig;
import org.projectnessie.client.util.v2api.ClientSideCreateNamespace;
import org.projectnessie.client.util.v2api.ClientSideDeleteNamespace;
import org.projectnessie.client.util.v2api.ClientSideGetMultipleNamespaces;
import org.projectnessie.client.util.v2api.ClientSideGetNamespace;
import org.projectnessie.client.util.v2api.ClientSideUpdateNamespace;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.SingleReferenceResponse;

public class HttpApiV2
implements NessieApiV2 {
    private final HttpClient client;

    public HttpApiV2(HttpClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public NessieConfiguration getConfig() {
        return this.client.newRequest().path("config").get().readEntity(NessieConfiguration.class);
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        return (Branch)this.client.newRequest().path("trees/-").unwrap(NessieNotFoundException.class).get().readEntity(SingleReferenceResponse.class).getReference();
    }

    @Override
    public GetContentBuilder getContent() {
        return new HttpGetContent(this.client);
    }

    @Override
    public GetAllReferencesBuilder getAllReferences() {
        return new HttpGetAllReferences(this.client);
    }

    @Override
    public CreateReferenceBuilder createReference() {
        return new HttpCreateReference(this.client);
    }

    @Override
    public GetReferenceBuilder getReference() {
        return new HttpGetReference(this.client);
    }

    @Override
    public GetEntriesBuilder getEntries() {
        return new HttpGetEntries(this.client);
    }

    @Override
    public GetCommitLogBuilder getCommitLog() {
        return new HttpGetCommitLog(this.client);
    }

    @Override
    public AssignTagBuilder assignTag() {
        return new HttpAssignTag(this.client);
    }

    @Override
    public DeleteTagBuilder deleteTag() {
        return new HttpDeleteTag(this.client);
    }

    @Override
    public AssignBranchBuilder assignBranch() {
        return new HttpAssignBranch(this.client);
    }

    @Override
    public DeleteBranchBuilder deleteBranch() {
        return new HttpDeleteBranch(this.client);
    }

    @Override
    public TransplantCommitsBuilder transplantCommitsIntoBranch() {
        return new HttpTransplantCommits(this.client);
    }

    @Override
    public MergeReferenceBuilder mergeRefIntoBranch() {
        return new HttpMergeReference(this.client);
    }

    @Override
    public CommitMultipleOperationsBuilder commitMultipleOperations() {
        return new HttpCommitMultipleOperations(this.client);
    }

    @Override
    public GetDiffBuilder getDiff() {
        return new HttpGetDiff(this.client);
    }

    @Override
    @Deprecated
    public GetRefLogBuilder getRefLog() {
        throw new UnsupportedOperationException("Reflog is not supported in API v2");
    }

    @Override
    public GetNamespaceBuilder getNamespace() {
        return new ClientSideGetNamespace(this);
    }

    @Override
    public GetMultipleNamespacesBuilder getMultipleNamespaces() {
        return new ClientSideGetMultipleNamespaces(this);
    }

    @Override
    public CreateNamespaceBuilder createNamespace() {
        return new ClientSideCreateNamespace(this);
    }

    @Override
    public DeleteNamespaceBuilder deleteNamespace() {
        return new ClientSideDeleteNamespace(this);
    }

    @Override
    public UpdateNamespaceBuilder updateProperties() {
        return new ClientSideUpdateNamespace(this);
    }

    @Override
    public GetRepositoryConfigBuilder getRepositoryConfig() {
        return new HttpGetRepositoryConfig(this.client);
    }

    @Override
    public UpdateRepositoryConfigBuilder updateRepositoryConfig() {
        return new HttpUpdateRepositoryConfig(this.client);
    }
}

