/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v2api;

import org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.model.ImmutableUpdateRepositoryConfigRequest;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.UpdateRepositoryConfigResponse;

final class HttpUpdateRepositoryConfig
implements UpdateRepositoryConfigBuilder {
    private final HttpClient client;
    private RepositoryConfig update;

    HttpUpdateRepositoryConfig(HttpClient client) {
        this.client = client;
    }

    @Override
    public UpdateRepositoryConfigBuilder repositoryConfig(RepositoryConfig update) {
        if (this.update != null) {
            throw new IllegalStateException("repository config to update has already been set");
        }
        this.update = update;
        return this;
    }

    @Override
    public UpdateRepositoryConfigResponse update() throws NessieConflictException {
        if (this.update == null) {
            throw new IllegalStateException("repository config to update must be set");
        }
        ImmutableUpdateRepositoryConfigRequest req = ImmutableUpdateRepositoryConfigRequest.builder().config(this.update).build();
        return this.client.newRequest().path("config/repository").unwrap(NessieConflictException.class).post(req).readEntity(UpdateRepositoryConfigResponse.class);
    }
}

