/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieUnavailableException;

public class ResponseCheckFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);

    public static void checkResponse(ResponseContext con) throws Exception {
        NessieServiceException exception;
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, MAPPER.reader());
        }
        Optional modelException = ErrorCode.asException((NessieError)error);
        if (modelException.isPresent()) {
            throw (Exception)modelException.get();
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                exception = new NessieInternalServerException(error);
                break;
            }
            case SERVICE_UNAVAILABLE: {
                exception = new NessieUnavailableException(error);
                break;
            }
            case UNAUTHORIZED: {
                exception = new NessieNotAuthorizedException(error);
                break;
            }
            default: {
                exception = new NessieServiceException(error);
            }
        }
        if (error.getClientProcessingException() != null) {
            exception.addSuppressed(error.getClientProcessingException());
        }
        throw exception;
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        NessieError error;
        if (inputStream == null) {
            error = ImmutableNessieError.builder().errorCode(ErrorCode.UNKNOWN).status(status.getCode()).reason(status.getReason()).message("Could not parse error object in response.").clientProcessingException((Exception)new RuntimeException("Could not parse error object in response.")).build();
        } else {
            try {
                JsonNode errorData = reader.readTree(inputStream);
                try {
                    error = (NessieError)reader.treeToValue((TreeNode)errorData, NessieError.class);
                }
                catch (JsonProcessingException e) {
                    error = ImmutableNessieError.builder().message(errorData.toString()).status(status.getCode()).reason(status.getReason()).clientProcessingException((Exception)((Object)e)).build();
                }
            }
            catch (IOException e) {
                error = ImmutableNessieError.builder().status(status.getCode()).reason(status.getReason()).clientProcessingException((Exception)e).build();
            }
        }
        return error;
    }
}

