/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class JwtToken {
    public static final String EXP_CLAIM = "exp";
    public static final String ISS_CLAIM = "iss";
    public static final String SUB_CLAIM = "sub";
    public static final String AUD_CLAIM = "aud";
    public static final String NBF_CLAIM = "nbf";
    public static final String IAT_CLAIM = "iat";
    public static final String JTI_CLAIM = "jti";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final JsonNode payload;
    private final ConcurrentMap<String, Object> claims;

    public static JwtToken parse(String token) {
        String[] parts;
        if (token != null && (parts = token.split("\\.")).length == 3 && parts[1].length() > 0) {
            try {
                JsonNode payload = OBJECT_MAPPER.readTree(Base64.getUrlDecoder().decode(parts[1]));
                return new JwtToken(payload);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid JWT token: " + token);
    }

    private JwtToken(JsonNode payload) {
        this.payload = payload;
        this.claims = new ConcurrentHashMap<String, Object>();
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    @Nullable
    public String getIssuer() {
        return (String)this.claims.computeIfAbsent(ISS_CLAIM, k -> this.payloadFieldValueTextual(ISS_CLAIM));
    }

    @Nullable
    public String getSubject() {
        return (String)this.claims.computeIfAbsent(SUB_CLAIM, k -> this.payloadFieldValueTextual(SUB_CLAIM));
    }

    @Nullable
    public String getAudience() {
        return (String)this.claims.computeIfAbsent(AUD_CLAIM, k -> this.payloadFieldValueTextual(AUD_CLAIM));
    }

    @Nullable
    public Instant getExpirationTime() {
        return (Instant)this.claims.computeIfAbsent(EXP_CLAIM, k -> this.payloadFieldValueInstant(EXP_CLAIM));
    }

    @Nullable
    public Instant getNotBefore() {
        return (Instant)this.claims.computeIfAbsent(NBF_CLAIM, k -> this.payloadFieldValueInstant(NBF_CLAIM));
    }

    @Nullable
    public Instant getIssuedAt() {
        return (Instant)this.claims.computeIfAbsent(IAT_CLAIM, k -> this.payloadFieldValueInstant(IAT_CLAIM));
    }

    @Nullable
    public String getId() {
        return (String)this.claims.computeIfAbsent(JTI_CLAIM, k -> this.payloadFieldValueTextual(JTI_CLAIM));
    }

    public String toString() {
        return "JwtToken" + this.payload;
    }

    private String payloadFieldValueTextual(String field) {
        return this.payloadFieldValue(field, JsonNode::isTextual, JsonNode::asText);
    }

    private Instant payloadFieldValueInstant(String field) {
        return this.payloadFieldValue(field, JsonNode::canConvertToLong, node -> Instant.ofEpochSecond(node.asLong()));
    }

    private <T> T payloadFieldValue(String field, Predicate<JsonNode> tester, Function<JsonNode, T> mapper) {
        JsonNode value = this.payload.get(field);
        if (value == null || value.isNull() || !tester.test(value)) {
            return null;
        }
        return mapper.apply(value);
    }
}

