/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.impl.HttpUtils;

public class UriBuilder {
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\+");
    private final URI baseUri;
    private final StringBuilder uri = new StringBuilder();
    private final StringBuilder query = new StringBuilder();
    private final Map<String, String> templateValues = new HashMap<String, String>();

    public UriBuilder(URI baseUri) {
        this.baseUri = Objects.requireNonNull(baseUri);
    }

    public UriBuilder path(String path) {
        String trimmedPath;
        if (this.uri.length() > 0) {
            this.uri.append('/');
        }
        HttpUtils.checkArgument(!(trimmedPath = HttpUtils.checkNonNullTrim(path)).isEmpty(), "Path %s must be of length greater than 0", trimmedPath);
        this.uri.append(trimmedPath);
        return this;
    }

    public UriBuilder queryParam(String name, String value) {
        if (value == null) {
            return this;
        }
        if (this.query.length() > 0) {
            this.query.append('&');
        }
        this.query.append(UriBuilder.encode(HttpUtils.checkNonNullTrim(name))).append('=').append(UriBuilder.encode(HttpUtils.checkNonNullTrim(value)));
        return this;
    }

    public UriBuilder resolveTemplate(String name, String value) {
        this.templateValues.put(HttpUtils.checkNonNullTrim(name), HttpUtils.checkNonNullTrim(value));
        return this;
    }

    private static void checkEmpty(Map<String, String> templates, StringBuilder uri) {
        if (!templates.isEmpty()) {
            String keys = String.join((CharSequence)";", templates.keySet());
            throw new HttpClientException(String.format("Cannot build uri. Not all template keys (%s) were used in uri %s", keys, uri));
        }
    }

    public URI build() throws HttpClientException {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(this.baseUri);
        if ('/' != uriBuilder.charAt(uriBuilder.length() - 1)) {
            uriBuilder.append('/');
        }
        if (this.uri.length() > 0) {
            HashMap<String, String> templates = new HashMap<String, String>(this.templateValues);
            StringBuilder pathElement = new StringBuilder();
            StringBuilder name = new StringBuilder();
            int l = this.uri.length();
            for (int i = 0; i < l; ++i) {
                char c = this.uri.charAt(i);
                if (c == '/') {
                    uriBuilder.append(UriBuilder.encode(pathElement.toString()));
                    pathElement.setLength(0);
                    uriBuilder.append('/');
                    continue;
                }
                if (c == '{') {
                    ++i;
                    while (i < l && (c = this.uri.charAt(i)) != '}') {
                        name.append(c);
                        ++i;
                    }
                    String value = (String)templates.remove(name.toString());
                    if (value != null) {
                        pathElement.append(value);
                    }
                    name.setLength(0);
                    continue;
                }
                pathElement.append(c);
            }
            uriBuilder.append(UriBuilder.encode(pathElement.toString()));
            UriBuilder.checkEmpty(templates, this.uri);
            if ('/' == uriBuilder.charAt(uriBuilder.length() - 1)) {
                return URI.create(uriBuilder.subSequence(0, uriBuilder.length() - 1).toString());
            }
        } else {
            UriBuilder.checkEmpty(this.templateValues, this.uri);
        }
        if (this.query.length() > 0) {
            uriBuilder.append("?");
            uriBuilder.append((CharSequence)this.query);
        }
        return URI.create(uriBuilder.toString());
    }

    private static String encode(String s) throws HttpClientException {
        try {
            return BACKSLASH_PATTERN.matcher(URLEncoder.encode(s, "UTF-8")).replaceAll("%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientException(String.format("Cannot url encode %s", s), e);
        }
    }
}

