/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api.ns;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseGetMultipleNamespacesBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.Namespace;

public final class ClientSideGetMultipleNamespaces
extends BaseGetMultipleNamespacesBuilder {
    private final NessieApiV2 api;
    private boolean onlyDirectChildren;

    public ClientSideGetMultipleNamespaces(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public GetMultipleNamespacesBuilder onlyDirectChildren(boolean onlyDirectChildren) {
        this.onlyDirectChildren = onlyDirectChildren;
        return this;
    }

    @Override
    public GetNamespacesResponse get() throws NessieReferenceNotFoundException {
        GetMultipleContentsResponse content;
        List<ContentKey> entries;
        try {
            GetEntriesBuilder getEntries = (GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(this.refName)).hashOnRef(this.hashOnRef);
            String filter = "entry.contentType == 'NAMESPACE'";
            if (this.namespace != null && !this.namespace.isEmpty()) {
                String nsName = this.namespace.name();
                filter = filter + (this.onlyDirectChildren ? String.format(" && size(entry.keyElements) == %d && entry.encodedKey.startsWith('%s.')", this.namespace.getElementCount() + 1, nsName) : String.format("&& (entry.encodedKey == '%s' || entry.encodedKey.startsWith('%s.'))", nsName, nsName));
            } else if (this.onlyDirectChildren) {
                filter = filter + " && size(entry.keyElements) == 1";
            }
            getEntries.filter(filter);
            entries = getEntries.stream().map(EntriesResponse.Entry::getName).collect(Collectors.toList());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        if (entries.isEmpty()) {
            return GetNamespacesResponse.builder().build();
        }
        try {
            GetContentBuilder getContent = (GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef);
            entries.forEach(getContent::key);
            content = getContent.getWithResponse();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        ImmutableGetNamespacesResponse.Builder builder = GetNamespacesResponse.builder().effectiveReference(content.getEffectiveReference());
        content.toContentsMap().values().stream().map(v -> v.unwrap(Namespace.class)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableGetNamespacesResponse.Builder)builder).addNamespaces(arg_0));
        return builder.build();
    }
}

