/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

class JacksonSerializers {
    private JacksonSerializers() {
    }

    static class SecondsToDurationDeserializer
    extends StdDeserializer<Duration> {
        public SecondsToDurationDeserializer() {
            super(Duration.class);
        }

        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentToken().isNumeric()) {
                int seconds = p.getValueAsInt();
                return Duration.ofSeconds(seconds);
            }
            return null;
        }
    }

    static class DurationToSecondsSerializer
    extends StdSerializer<Duration> {
        public DurationToSecondsSerializer() {
            super(Duration.class);
        }

        public void serialize(Duration value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(value.getSeconds());
            }
        }
    }

    static class SecondsToInstantDeserializer
    extends StdDeserializer<Instant> {
        public SecondsToInstantDeserializer() {
            super(Instant.class);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentToken().isNumeric()) {
                int seconds = p.getValueAsInt();
                return Instant.now().plusSeconds(seconds);
            }
            return null;
        }
    }

    static class InstantToSecondsSerializer
    extends StdSerializer<Instant> {
        public InstantToSecondsSerializer() {
            super(Instant.class);
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(Duration.between(Instant.now(), value).getSeconds());
            }
        }
    }
}

