/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.config;

import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NessieClientConfigSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieClientConfigSources.class);
    private static final NessieClientConfigSource EMPTY_CONFIG_SOURCE = new NessieClientConfigSource(){

        @Override
        @Nullable
        @jakarta.annotation.Nullable
        public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
            return null;
        }
    };

    private NessieClientConfigSources() {
    }

    public static NessieClientConfigSource dotEnvFileConfigSource() {
        Path dotEnvFile = NessieClientConfigSources.dotEnvFile();
        return NessieClientConfigSources.environmentFileConfigSource(dotEnvFile);
    }

    public static NessieClientConfigSource nessieClientConfigFileConfigSource() {
        Path propertiesFile = NessieClientConfigSources.nessieClientConfigFile();
        return NessieClientConfigSources.propertiesFileConfigSource(propertiesFile);
    }

    public static NessieClientConfigSource systemEnvironmentConfigSource() {
        return NessieClientConfigSources.environmentConfigSource(System.getenv());
    }

    public static NessieClientConfigSource systemPropertiesConfigSource() {
        return NessieClientConfigSources.propertiesConfigSource(System.getProperties());
    }

    public static NessieClientConfigSource environmentFileConfigSource(final Path envFile) {
        if (!Files.isRegularFile(envFile, new LinkOption[0])) {
            return EMPTY_CONFIG_SOURCE;
        }
        final Properties props = NessieClientConfigSources.loadProperties(envFile);
        return new NessieClientConfigSource(){

            @Override
            @Nullable
            @jakarta.annotation.Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String envName = NessieClientConfigSources.propertyNameToEnvironmentName(key);
                String v = props.getProperty(envName);
                LOGGER.debug("Config value for key {} as {} retrieved from {}", new Object[]{key, envName, envFile});
                return v;
            }
        };
    }

    public static NessieClientConfigSource environmentConfigSource(final Map<String, String> environment) {
        return new NessieClientConfigSource(){

            @Override
            @Nullable
            @jakarta.annotation.Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String envName = NessieClientConfigSources.propertyNameToEnvironmentName(key);
                String v = (String)environment.get(envName);
                LOGGER.debug("Config value for key {} as {} retrieved from environment", (Object)key, (Object)envName);
                return v;
            }
        };
    }

    public static NessieClientConfigSource propertiesFileConfigSource(final Path propertiesFile) {
        if (!Files.isRegularFile(propertiesFile, new LinkOption[0])) {
            return EMPTY_CONFIG_SOURCE;
        }
        final Properties props = NessieClientConfigSources.loadProperties(propertiesFile);
        return new NessieClientConfigSource(){

            @Override
            @Nullable
            @jakarta.annotation.Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = props.getProperty(key);
                LOGGER.debug("Config value for key {} retrieved from {}", (Object)key, (Object)propertiesFile);
                return v;
            }
        };
    }

    public static NessieClientConfigSource propertiesConfigSource(final Properties properties) {
        return new NessieClientConfigSource(){

            @Override
            @Nullable
            @jakarta.annotation.Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = properties.getProperty(key);
                LOGGER.debug("Config value for key {} retrieved from properties", (Object)key);
                return v;
            }
        };
    }

    public static NessieClientConfigSource mapConfigSource(final Map<String, String> properties) {
        return new NessieClientConfigSource(){

            @Override
            @Nullable
            @jakarta.annotation.Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = (String)properties.get(key);
                LOGGER.debug("Config value for key {} retrieved from map", (Object)key);
                return v;
            }
        };
    }

    public static String propertyNameToEnvironmentName(String propertyName) {
        return propertyName.toUpperCase(Locale.ROOT).replace('.', '_').replace('-', '_');
    }

    public static NessieClientConfigSource defaultConfigSources() {
        return NessieClientConfigSources.systemPropertiesConfigSource().fallbackTo(NessieClientConfigSources.systemEnvironmentConfigSource()).fallbackTo(NessieClientConfigSources.nessieClientConfigFileConfigSource()).fallbackTo(NessieClientConfigSources.dotEnvFileConfigSource());
    }

    public static NessieClientConfigSource emptyConfigSource() {
        return EMPTY_CONFIG_SOURCE;
    }

    static Path dotEnvFile() {
        return Paths.get(System.getProperty("user.dir"), ".env");
    }

    static Path nessieClientConfigFile() {
        return Paths.get(System.getProperty("user.dir"), ".config", "nessie", "nessie-client.properties");
    }

    private static Properties loadProperties(Path propertiesFile) {
        Properties props = new Properties();
        try (BufferedReader input = Files.newBufferedReader(propertiesFile);){
            props.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }
}

