/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth2TokenRefreshExecutor
extends ScheduledThreadPoolExecutor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2TokenRefreshExecutor.class);

    OAuth2TokenRefreshExecutor(Duration keepAlive) {
        super(1, new OAuth2TokenRefreshThreadFactory());
        this.setKeepAliveTime(keepAlive.toNanos(), TimeUnit.NANOSECONDS);
        this.allowCoreThreadTimeOut(true);
    }

    @Override
    public void close() {
        if (!this.isShutdown()) {
            this.shutdown();
            try {
                if (!this.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("OAuth2 token refresh executor did not terminate within 10 seconds");
                    this.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("OAuth2 token refresh executor termination interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class OAuth2TokenRefreshThreadFactory
    implements ThreadFactory {
        private OAuth2TokenRefreshThreadFactory() {
        }

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            TokenRefreshThread thread = new TokenRefreshThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static final class TokenRefreshThread
    extends Thread {
        TokenRefreshThread(Runnable r) {
            super(r, "nessie-client-oauth2-token-refresh");
        }

        @Override
        public void run() {
            LOGGER.debug("Starting new OAuth2 token refresh thread");
            try {
                super.run();
            }
            finally {
                LOGGER.debug("OAuth2 token refresh thread exiting");
            }
        }
    }
}

