/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClients;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.NessieApiCompatibilityFilter;
import org.projectnessie.client.http.NessieHttpClientBuilder;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.client.rest.v1.HttpApiV1;
import org.projectnessie.client.rest.v1.RestV1Client;
import org.projectnessie.client.rest.v2.HttpApiV2;
import org.projectnessie.model.ser.Views;

public class NessieHttpClientBuilderImpl
extends NessieHttpClientBuilder.AbstractNessieHttpClientBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final HttpClient.Builder builder = HttpClient.builder().setObjectMapper(MAPPER).addResponseFilter(new NessieHttpResponseFilter());
    private boolean tracing;
    private boolean enableApiCompatibilityCheck = Boolean.parseBoolean(System.getProperty("nessie.enable-api-compatibility-check", "true"));

    @Override
    public String name() {
        return "HTTP";
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withUri(URI uri) {
        this.builder.setBaseUri(uri);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withAuthentication(NessieAuthentication authentication) {
        if (authentication != null && !(authentication instanceof HttpAuthentication)) {
            throw new IllegalArgumentException("HttpClientBuilder only accepts instances of HttpAuthentication");
        }
        this.builder.setAuthentication((HttpAuthentication)authentication);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withTracing(boolean tracing) {
        this.tracing = tracing;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withReadTimeout(int readTimeoutMillis) {
        this.builder.setReadTimeoutMillis(readTimeoutMillis);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withConnectionTimeout(int connectionTimeoutMillis) {
        this.builder.setConnectionTimeoutMillis(connectionTimeoutMillis);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withDisableCompression(boolean disableCompression) {
        this.builder.setDisableCompression(disableCompression);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withSSLContext(SSLContext sslContext) {
        this.builder.setSslContext(sslContext);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withSSLParameters(SSLParameters sslParameters) {
        this.builder.setSslParameters(sslParameters);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withHttp2Upgrade(boolean http2Upgrade) {
        this.builder.setHttp2Upgrade(http2Upgrade);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withFollowRedirects(String redirects) {
        this.builder.setFollowRedirects(redirects);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withForceUrlConnectionClient(boolean forceUrlConnectionClient) {
        this.builder.setForceUrlConnectionClient(forceUrlConnectionClient);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withApiCompatibilityCheck(boolean enable) {
        this.enableApiCompatibilityCheck = enable;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl withResponseFactory(HttpResponseFactory responseFactory) {
        this.builder.setResponseFactory(responseFactory);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl addRequestFilter(RequestFilter filter) {
        this.builder.addRequestFilter(filter);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilderImpl addResponseFilter(ResponseFilter filter) {
        this.builder.addResponseFilter(filter);
        return this;
    }

    @Override
    public NessieHttpClientBuilderImpl fromConfig(Function<String, String> configuration) {
        return (NessieHttpClientBuilderImpl)super.fromConfig((Function)configuration);
    }

    @Override
    public NessieHttpClientBuilderImpl withAuthenticationFromConfig(Function<String, String> configuration) {
        return (NessieHttpClientBuilderImpl)super.withAuthenticationFromConfig((Function)configuration);
    }

    @Override
    public NessieHttpClientBuilderImpl withUri(String uri) {
        return (NessieHttpClientBuilderImpl)super.withUri(uri);
    }

    @Override
    public <API extends NessieApi> API build(Class<API> apiVersion) {
        Objects.requireNonNull(apiVersion, "API version class must be non-null");
        if (this.tracing) {
            this.builder.addTracing();
        }
        if (apiVersion.isAssignableFrom(HttpApiV1.class)) {
            if (this.enableApiCompatibilityCheck) {
                this.builder.addRequestFilter(new NessieApiCompatibilityFilter(this.builder, 1));
            }
            this.builder.setJsonView(Views.V1.class);
            HttpClient httpClient = HttpClients.buildClient(this.tracing, this.builder);
            return (API)((NessieApi)apiVersion.cast(new HttpApiV1(new RestV1Client(httpClient))));
        }
        if (apiVersion.isAssignableFrom(HttpApiV2.class)) {
            if (this.enableApiCompatibilityCheck) {
                this.builder.addRequestFilter(new NessieApiCompatibilityFilter(this.builder, 2));
            }
            this.builder.setJsonView(Views.V2.class);
            HttpClient httpClient = HttpClients.buildClient(this.tracing, this.builder);
            return (API)((NessieApi)apiVersion.cast(new HttpApiV2(httpClient)));
        }
        throw new IllegalArgumentException(String.format("API version %s is not supported.", apiVersion.getName()));
    }
}

