/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import org.projectnessie.client.auth.oauth2.Flow;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;
import org.projectnessie.client.auth.oauth2.TokensResponseBase;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;

abstract class AbstractFlow
implements Flow {
    final OAuth2ClientConfig config;

    AbstractFlow(OAuth2ClientConfig config) {
        this.config = config;
    }

    <T> T invokeEndpoint(URI endpoint, Object request, Class<? extends T> responseClass) {
        HttpRequest req = this.config.getHttpClient().newRequest(endpoint);
        this.config.getBasicAuthentication().ifPresent(req::authentication);
        HttpResponse response = req.postForm(request);
        return response.readEntity(responseClass);
    }

    <T extends TokensResponseBase> T invokeTokenEndpoint(TokensRequestBase request, Class<? extends T> responseClass) {
        return (T)((TokensResponseBase)this.invokeEndpoint(this.config.getResolvedTokenEndpoint(), request, responseClass));
    }
}

